/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.util;

import java.util.HashMap;
import java.util.Map;

public enum EventQuality {
    NONE(0),
    A(10),
    B(20),
    C(30),
    D(40);

    private static Map<Integer, EventQuality> idMap;
    private int id;

    private EventQuality(int id) {
        this.id = id;
    }

    public EventQuality typeForID(int id) {
        return idMap.get(id);
    }

    public int id() {
        return this.id;
    }

    public static EventQuality parse(String s) {
        try {
            return EventQuality.valueOf(EventQuality.class, s.trim().toUpperCase());
        }
        catch (Exception exception) {
            return NONE;
        }
    }

    static {
        idMap = new HashMap<Integer, EventQuality>();
        for (EventQuality mt : EventQuality.values()) {
            idMap.put(mt.id(), mt);
        }
    }
}

