/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.geo;

import java.awt.geom.Path2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import org.apache.commons.io.IOUtils;
import org.dom4j.Element;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.metadata.XMLSaveable;

public class LocationList
extends ArrayList<Location>
implements XMLSaveable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String XML_METADATA_NAME = "LocationList";

    public LocationList() {
    }

    public LocationList(Collection<? extends Location> c) {
        super(c);
    }

    public LocationList(int initialCapacity) {
        super(initialCapacity);
    }

    public static LocationList of(Location ... locs) {
        LocationList ret = new LocationList(locs.length);
        for (Location loc : locs) {
            ret.add(loc);
        }
        return ret;
    }

    public void reverse() {
        Collections.reverse(this);
    }

    public List<LocationList> split(int size) {
        ArrayList<LocationList> lists = new ArrayList<LocationList>();
        if (size <= 0 || this.size() <= size) {
            lists.add(this);
            return lists;
        }
        LocationList cur = new LocationList();
        for (int i = 0; i < this.size(); ++i) {
            if (i % size == 0 && i > 0) {
                lists.add(cur);
                cur = new LocationList();
            }
            cur.add((Location)this.get(i));
        }
        if (cur.size() > 0) {
            lists.add(cur);
        }
        return lists;
    }

    public Path2D toPath() {
        Path2D.Double path = new Path2D.Double(0, this.size());
        boolean starting = true;
        for (Location loc : this) {
            double lat = loc.getLatitude();
            double lon = loc.getLongitude();
            if (starting) {
                ((Path2D)path).moveTo(lon, lat);
                starting = false;
                continue;
            }
            ((Path2D)path).lineTo(lon, lat);
        }
        path.closePath();
        return path;
    }

    public double minDistToLocation(Location loc) {
        double min = Double.MAX_VALUE;
        double dist = 0.0;
        for (Location p : this) {
            dist = LocationUtils.horzDistanceFast(loc, p);
            if (!(dist < min)) continue;
            min = dist;
        }
        return min;
    }

    public double minDistToLine(Location loc) {
        double min = Double.MAX_VALUE;
        double dist = 0.0;
        for (int i = 1; i < this.size(); ++i) {
            dist = Math.abs(LocationUtils.distanceToLineSegmentFast((Location)this.get(i - 1), (Location)this.get(i), loc));
            if (!(dist < min)) continue;
            min = dist;
        }
        return min;
    }

    public LocationList subList(int fromIndex, int toIndex) {
        List source = super.subList(fromIndex, toIndex);
        LocationList subLocList = new LocationList();
        for (Location loc : source) {
            subLocList.add(loc.clone());
        }
        return subLocList;
    }

    @Override
    public LocationList clone() {
        LocationList clone = new LocationList();
        for (Location loc : this) {
            clone.add(loc.clone());
        }
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LocationList)) {
            return false;
        }
        LocationList ll = (LocationList)obj;
        if (this.size() != ll.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((Location)this.get(i)).equals(ll.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int v = 0;
        boolean add = true;
        for (Location loc : this) {
            int locCode = loc.hashCode() / 1000;
            v = add ? v + locCode : v - locCode;
            add = !add;
        }
        return v;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer().append("List size: ").append(this.size()).append(IOUtils.LINE_SEPARATOR).append("Locations: ");
        for (Location loc : this) {
            b.append(loc).append(IOUtils.LINE_SEPARATOR).append("           ");
        }
        return b.toString();
    }

    @Override
    public Element toXMLMetadata(Element root) {
        return this.toXMLMetadata(root, XML_METADATA_NAME);
    }

    public Element toXMLMetadata(Element root, String elemName) {
        Element locs = root.addElement(elemName);
        for (int i = 0; i < this.size(); ++i) {
            Location loc = (Location)this.get(i);
            locs = loc.toXMLMetadata(locs);
        }
        return root;
    }

    public static LocationList fromXMLMetadata(Element locationElement) {
        LocationList locs = new LocationList();
        Iterator it = locationElement.elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (!el.getName().equals("Location")) continue;
            locs.add(Location.fromXMLMetadata(el));
        }
        return locs;
    }

    public LocationList unmodifiableList() {
        return new UnmodifiableLocationList(this);
    }

    public Location first() {
        return (Location)this.get(0);
    }

    public Location last() {
        return (Location)this.get(this.size() - 1);
    }

    public int minDistIndex(Location loc) {
        double min = Double.MAX_VALUE;
        int minIdx = -1;
        for (int i = 0; i < this.size() - 1; ++i) {
            double dist = LocationUtils.distanceToLineSegmentFast((Location)this.get(i), (Location)this.get(i + 1), loc);
            if (!(dist < min)) continue;
            min = dist;
            minIdx = i;
        }
        return minIdx;
    }

    public int closestPoint(Location loc) {
        double min = Double.MAX_VALUE;
        int minIdx = -1;
        for (int i = 0; i < this.size(); ++i) {
            double dist = LocationUtils.horzDistanceFast(loc, (Location)this.get(i));
            if (!(dist < min)) continue;
            min = dist;
            minIdx = i;
        }
        return minIdx;
    }

    private static final class UnmodifiableLocationList
    extends LocationList {
        private static final long serialVersionUID = 1L;
        final LocationList ll;

        UnmodifiableLocationList(LocationList ll) {
            this.ll = ll;
        }

        @Override
        public LocationList clone() {
            return this.ll.clone();
        }

        @Override
        public boolean contains(Object o) {
            return this.ll.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            return this.ll.containsAll(coll);
        }

        @Override
        public boolean equals(Object o) {
            return this.ll.equals(o);
        }

        @Override
        public Location get(int index) {
            return (Location)this.ll.get(index);
        }

        @Override
        public int hashCode() {
            return this.ll.hashCode();
        }

        @Override
        public int indexOf(Object o) {
            return this.ll.indexOf(o);
        }

        @Override
        public boolean isEmpty() {
            return this.ll.isEmpty();
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.ll.lastIndexOf(o);
        }

        @Override
        public int size() {
            return this.ll.size();
        }

        @Override
        public Object[] toArray() {
            return this.ll.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.ll.toArray(a);
        }

        @Override
        public String toString() {
            return this.ll.toString();
        }

        @Override
        public LocationList subList(int fromIndex, int toIndex) {
            return this.ll.subList(fromIndex, toIndex);
        }

        @Override
        public boolean add(Location e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Location element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Location> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Location> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Location remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Location set(int index, Location element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Location> iterator() {
            return new Iterator<Location>(){
                Iterator<? extends Location> it;
                {
                    this.it = ll.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Location next() {
                    return this.it.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public ListIterator<Location> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<Location> listIterator(final int index) {
            return new ListIterator<Location>(){
                ListIterator<? extends Location> it;
                final /* synthetic */ UnmodifiableLocationList this$0;
                {
                    this.this$0 = this$0;
                    this.it = this.this$0.ll.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Location next() {
                    return this.it.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this.it.hasPrevious();
                }

                @Override
                public Location previous() {
                    return this.it.previous();
                }

                @Override
                public int nextIndex() {
                    return this.it.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.it.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(Location e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(Location e) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Spliterator<Location> spliterator() {
            return this.ll.spliterator();
        }
    }
}

