/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.geo.json;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.opensha.commons.geo.json.AbstractGeoJSON_TypeAdapter;
import org.opensha.commons.geo.json.FeatureCollection;
import org.opensha.commons.geo.json.FeatureProperties;
import org.opensha.commons.geo.json.GeoJSON_Type;
import org.opensha.commons.geo.json.Geometry;
import org.opensha.commons.util.ExceptionUtils;

@JsonAdapter(value=FeatureAdapter.class)
public class Feature {
    public final Object id;
    public final GeoJSON_Type type = GeoJSON_Type.Feature;
    public final Geometry geometry;
    public final FeatureProperties properties;

    public Feature(Geometry geometry, FeatureProperties properties) {
        this.id = null;
        this.geometry = geometry;
        this.properties = properties;
    }

    private Feature(Object id, Geometry geometry, FeatureProperties properties) {
        this.id = id;
        this.geometry = geometry;
        this.properties = properties;
    }

    public Feature(Number id, Geometry geometry, FeatureProperties properties) {
        this.id = id;
        this.geometry = geometry;
        this.properties = properties;
    }

    public Feature(String id, Geometry geometry, FeatureProperties properties) {
        this.id = id;
        this.geometry = geometry;
        this.properties = properties;
    }

    public String toJSON() {
        StringWriter writer = new StringWriter();
        try {
            Feature.write(this, writer);
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        return writer.toString();
    }

    public String toCompactJSON() {
        StringWriter writer = new StringWriter();
        try {
            Feature.writeCompact(this, writer);
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        return writer.toString();
    }

    public static Feature fromJSON(String json) throws IOException {
        StringReader reader = new StringReader(json);
        return Feature.read(reader);
    }

    public static Feature read(File jsonFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        return Feature.read(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Feature read(Reader reader) throws IOException {
        Feature ret;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        Gson gson = FeatureCollection.gson_default;
        synchronized (gson) {
            ret = (Feature)FeatureCollection.gson_default.fromJson(reader, Feature.class);
            reader.close();
        }
        return ret;
    }

    public static void write(Feature feature, File jsonFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(jsonFile));
        Feature.write(feature, writer);
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Feature feature, Writer writer) throws IOException {
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        Gson gson = FeatureCollection.gson_default;
        synchronized (gson) {
            FeatureCollection.gson_default.toJson((Object)feature, Feature.class, (Appendable)writer);
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCompact(Feature feature, Writer writer) throws IOException {
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        Gson gson = FeatureCollection.gson_compact;
        synchronized (gson) {
            FeatureCollection.gson_compact.toJson((Object)feature, Feature.class, (Appendable)writer);
            writer.flush();
        }
    }

    public static Feature getWithID(Feature feature, Number id) {
        return new Feature(id, feature.geometry, feature.properties);
    }

    public static Feature getWithID(Feature feature, String id) {
        return new Feature(id, feature.geometry, feature.properties);
    }

    public static class FeatureAdapter
    extends AbstractGeoJSON_TypeAdapter<Feature> {
        private TypeAdapter<FeatureProperties> propsAdapter;
        private Geometry.GeometryAdapter geomAdapter = new Geometry.GeometryAdapter();

        public FeatureAdapter() {
            this.propsAdapter = new FeatureProperties.PropertiesAdapter();
            this.geomAdapter = new Geometry.GeometryAdapter();
        }

        public FeatureAdapter(TypeAdapter<FeatureProperties> propsAdapter, Geometry.GeometryAdapter geomAdapter) {
            this.propsAdapter = propsAdapter;
            this.geomAdapter = geomAdapter;
        }

        public void write(JsonWriter out, Feature value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value(value.type.name());
            if (value.id != null) {
                out.name("id");
                if (value.id instanceof Number) {
                    out.value((Number)value.id);
                } else {
                    out.value(value.id.toString());
                }
            }
            out.name("properties");
            if (value.properties == null) {
                out.beginObject().endObject();
            } else {
                this.propsAdapter.write(out, (Object)value.properties);
            }
            out.name("geometry");
            if (value.geometry == null) {
                out.nullValue();
            } else {
                this.geomAdapter.write(out, value.geometry);
            }
            out.endObject();
        }

        public Feature read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            Feature feature = this.innerReadAsType(in, null);
            in.endObject();
            return feature;
        }

        @Override
        public Feature innerReadAsType(JsonReader in, GeoJSON_Type type) throws IOException {
            Object id = null;
            Geometry geometry = null;
            FeatureProperties properties = null;
            block12: while (in.hasNext()) {
                String name = in.nextName();
                JsonToken peek = in.peek();
                switch (name) {
                    case "type": {
                        type = GeoJSON_Type.valueOf(in.nextString());
                        Preconditions.checkState((type == GeoJSON_Type.Feature ? 1 : 0) != 0, (String)"Expected Feature type, have %s", (Object)((Object)type));
                        continue block12;
                    }
                    case "id": {
                        if (peek == JsonToken.NUMBER) {
                            id = FeatureProperties.parseNumber(in.nextString());
                            continue block12;
                        }
                        id = in.nextString();
                        continue block12;
                    }
                    case "geometry": {
                        if (peek == JsonToken.NULL) {
                            in.nextNull();
                            continue block12;
                        }
                        geometry = this.geomAdapter.read(in);
                        continue block12;
                    }
                    case "properties": {
                        if (peek == JsonToken.NULL) {
                            in.nextNull();
                            continue block12;
                        }
                        properties = (FeatureProperties)this.propsAdapter.read(in);
                        continue block12;
                    }
                }
                in.skipValue();
            }
            Preconditions.checkState((type == GeoJSON_Type.Feature ? 1 : 0) != 0, (String)"Expected Feature type, have %s", (Object)((Object)type));
            return new Feature(id, geometry, properties);
        }
    }
}

