/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui;

import java.awt.Frame;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ConsoleWindow {
    private JDialog frame;
    private JTextArea text = new JTextArea();
    private JScrollPane scroll = new JScrollPane(this.text);

    public ConsoleWindow() {
        this(false);
    }

    public ConsoleWindow(boolean noFrame) {
        System.setErr(new ConsoleStream(System.err));
        System.setOut(new ConsoleStream(System.out));
        this.initGUI(noFrame);
    }

    public void initGUI(boolean noFrame) {
        if (!noFrame) {
            this.frame = new JDialog((Frame)new JFrame(), "Console Window");
            this.frame.setLocationRelativeTo(null);
            this.frame.setSize(800, 500);
            this.frame.add(this.scroll);
        }
        this.text.setEditable(false);
    }

    public JScrollPane getScrollPane() {
        return this.scroll;
    }

    public JTextArea getTextArea() {
        return this.text;
    }

    public void setVisible(boolean show) {
        if (this.frame != null) {
            this.frame.setLocationRelativeTo(null);
            this.text.setCaretPosition(0);
            this.text.setCaretPosition(this.text.getText().length());
            this.frame.setVisible(show);
        }
    }

    private class ConsoleStream
    extends PrintStream {
        public ConsoleStream(OutputStream stream) {
            super(stream);
        }

        private void write(String s) {
            ConsoleWindow.this.text.append(s);
            ConsoleWindow.this.text.setCaretPosition(ConsoleWindow.this.text.getText().length());
        }

        @Override
        public void write(int i) {
            this.write(new String(new byte[]{(byte)i}));
            super.write(i);
        }

        @Override
        public void write(byte[] bytes, int i, int j) {
            this.write(new String(bytes, i, j));
            super.write(bytes, i, j);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.write(new String(bytes));
            super.write(bytes);
        }
    }
}

