/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class LabeledBorderPanel
extends JPanel {
    protected static final String C = "LabeledBorderPanel";
    protected static final boolean D = false;
    protected JScrollPane jScrollPane1 = new JScrollPane();
    protected JPanel editorPanel = new JPanel();
    protected static GridBagLayout GBL = new GridBagLayout();
    protected String title;
    protected Color borderColor = new Color(80, 80, 133);
    protected boolean addDefault = true;
    protected JPanel mainPanel = new JPanel();
    LineBorder border1;
    TitledBorder titledBorder1;
    private boolean useScrollPane;
    public static Font PARAMETER_LABEL_FONT = new Font("SansSerif", 1, 12);
    public static Color PARAMTER_FORE_COLOR = new Color(80, 80, 140);

    public LabeledBorderPanel(LayoutManager layout, boolean isDoubleBuffered, boolean useScrollPane) {
        super(layout, isDoubleBuffered);
        this.useScrollPane = useScrollPane;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.editorPanel != null) {
            this.editorPanel.setLayout(layout);
        }
    }

    public LabeledBorderPanel(LayoutManager layout) {
        this(layout, true, true);
    }

    public LabeledBorderPanel(boolean isDoubleBuffered) {
        this(new FlowLayout(), isDoubleBuffered, true);
    }

    public LabeledBorderPanel() {
        this(new FlowLayout(), true, true);
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (this.addDefault) {
            super.setLayout(mgr);
        } else if (this.editorPanel != null) {
            this.editorPanel.setLayout(mgr);
        }
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
        if (this.titledBorder1 != null) {
            this.titledBorder1.setTitle(this.title);
            this.mainPanel.repaint();
        }
    }

    public void initParameterLookAndFeel() {
        this.setBackground(null);
        this.editorPanel.setBackground(null);
        this.mainPanel.setBackground(null);
        this.setBorderColor(PARAMTER_FORE_COLOR);
        this.setTitleFont(PARAMETER_LABEL_FONT);
    }

    public void setBorderColor(Color newBorderColor) {
        this.borderColor = newBorderColor;
        if (this.border1 != null) {
            this.border1 = (LineBorder)BorderFactory.createLineBorder(newBorderColor, 1);
        }
        if (this.titledBorder1 != null) {
            this.titledBorder1.setBorder(this.border1);
            this.titledBorder1.setTitleColor(newBorderColor);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setTitleJustification(int justification) {
        if (this.titledBorder1 != null) {
            this.titledBorder1.setTitleJustification(justification);
        }
    }

    public void setTitlePosition(int position) {
        if (this.titledBorder1 != null) {
            this.titledBorder1.setTitlePosition(position);
        }
    }

    public void setTitleFont(Font font) {
        if (this.titledBorder1 != null) {
            this.titledBorder1.setTitleFont(font);
        }
    }

    protected void jbInit() throws Exception {
        this.addDefault = true;
        this.border1 = (LineBorder)BorderFactory.createLineBorder(SystemColor.activeCaption, 1);
        this.titledBorder1 = new TitledBorder(this.border1, "Title");
        this.titledBorder1.setTitleColor(SystemColor.activeCaption);
        this.titledBorder1.setTitleFont(new Font("Dialog", 1, 11));
        this.setBackground(Color.white);
        this.setFont(new Font("Dialog", 1, 11));
        this.setBorder(null);
        this.setLayout(GBL);
        this.editorPanel.setLayout(GBL);
        this.editorPanel.setBackground(Color.white);
        this.jScrollPane1.setBorder(null);
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBackground(Color.white);
        this.mainPanel.setBorder(this.titledBorder1);
        JComponent compToAdd = this.useScrollPane ? this.jScrollPane1 : this.editorPanel;
        this.mainPanel.add((Component)compToAdd, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 7, 3, 8), 0, 0));
        this.add((Component)this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.useScrollPane) {
            this.jScrollPane1.getViewport().add((Component)this.editorPanel, null);
        }
        this.addDefault = false;
    }

    @Override
    public Component add(Component comp) {
        if (this.addDefault) {
            return super.add(comp);
        }
        return this.editorPanel.add(comp);
    }

    @Override
    public Component add(String name, Component comp) {
        if (this.addDefault) {
            return super.add(name, comp);
        }
        return this.editorPanel.add(name, comp);
    }

    @Override
    public Component add(Component comp, int index) {
        if (this.addDefault) {
            return super.add(comp, index);
        }
        return this.editorPanel.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (this.addDefault) {
            super.add(comp, constraints);
        } else {
            this.editorPanel.add(comp, constraints);
        }
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        if (this.addDefault) {
            super.add(comp, constraints, index);
        } else {
            this.editorPanel.add(comp, constraints, index);
        }
    }

    @Override
    public void remove(int index) {
        if (this.addDefault) {
            super.remove(index);
        } else {
            this.editorPanel.remove(index);
        }
    }

    @Override
    public void remove(Component comp) {
        if (this.addDefault) {
            super.remove(comp);
        } else {
            this.editorPanel.remove(comp);
        }
    }

    @Override
    public void removeAll() {
        if (this.addDefault) {
            super.removeAll();
        } else {
            this.editorPanel.removeAll();
        }
    }
}

