/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensha.commons.data.WeightedList;

public class WeightedListGUI
extends JPanel
implements ChangeListener,
ItemListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private static final DecimalFormat df = new DecimalFormat("0.0000");
    private ArrayList<JSlider> sliders;
    private ArrayList<JTextField> textFields;
    public static final int MINIMUM_WIDTH = 200;
    private WeightedList<?> list;
    private JScrollPane editorsScroll;
    private JPanel editorsPanel;
    private static final String SET_NAME = "Set Weights...";
    private static final String SET_NORMALIZED = "Normalized";
    private static final String SET_EQUAL = "Equal";
    private static final String SET_ZERO = "Zero";
    private static final String SET_ONE = "One";
    private JComboBox setCombo;

    public WeightedListGUI(WeightedList<?> list) {
        super(new BorderLayout());
        this.init();
        this.setList(list);
    }

    private void init() {
        this.editorsPanel = new JPanel();
        this.editorsScroll = new JScrollPane(this.editorsPanel);
        this.add((Component)this.editorsScroll, "Center");
        String[] items = new String[]{SET_NAME, SET_NORMALIZED, SET_EQUAL, SET_ZERO, SET_ONE};
        this.setCombo = new JComboBox<String>(items);
        this.setCombo.setSelectedIndex(0);
        this.setCombo.addItemListener(this);
        this.add((Component)this.setCombo, "South");
    }

    public void setList(WeightedList<?> list) {
        this.list = list;
        this.editorsPanel.removeAll();
        if (list == null || list.size() == 0) {
            return;
        }
        this.sliders = new ArrayList();
        this.textFields = new ArrayList();
        this.editorsPanel.setLayout(new BoxLayout(this.editorsPanel, 1));
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            JSlider slide = new JSlider(this.weightToPos(list.getWeightValueMin()), this.weightToPos(list.getWeightValueMax()));
            JTextField field = new JTextField(5);
            this.sliders.add(slide);
            this.textFields.add(field);
            JPanel editorPanel = new JPanel();
            editorPanel.setLayout(new BoxLayout(editorPanel, 0));
            String name = WeightedList.getName(obj);
            this.editorsPanel.add(new JLabel(name));
            editorPanel.add(slide);
            JPanel fieldPanel = new JPanel();
            fieldPanel.add(field);
            editorPanel.add(fieldPanel);
            JPanel editorWrap = new JPanel();
            editorWrap.add(editorPanel);
            this.editorsPanel.add(editorWrap);
        }
        this.updateSliders();
        for (JSlider slide : this.sliders) {
            slide.addChangeListener(this);
        }
        for (JTextField field : this.textFields) {
            field.addKeyListener(this);
            field.addFocusListener(this);
        }
        this.editorsScroll.setPreferredSize(new Dimension(200, 200));
        this.editorsScroll.invalidate();
    }

    private void updateSliders() {
        for (int i = 0; i < this.list.size(); ++i) {
            double weight = this.list.getWeight(i);
            int pos = this.weightToPos(weight);
            this.sliders.get(i).setValue(pos);
            this.textFields.get(i).setText(df.format(weight));
        }
    }

    private int weightToPos(double weight) {
        return (int)(weight * 100.0 + 0.5);
    }

    private double posToWeight(int pos) {
        return (double)pos / 100.0;
    }

    private double getFormattedDouble(double weight) {
        String str = df.format(weight);
        return Double.valueOf(str);
    }

    private void weightUpdated(int i, double newWeight) {
        double fieldValue;
        this.list.setWeight(i, newWeight);
        int sliderPos = this.weightToPos(newWeight);
        JSlider slider = this.sliders.get(i);
        JTextField field = this.textFields.get(i);
        if (sliderPos != slider.getValue()) {
            slider.setValue(sliderPos);
        }
        if ((fieldValue = Double.valueOf(field.getText()).doubleValue()) != this.getFormattedDouble(newWeight)) {
            field.setText(df.format(newWeight));
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JSlider) {
            for (int i = 0; i < this.sliders.size(); ++i) {
                JSlider slider = this.sliders.get(i);
                if (slider != e.getSource()) continue;
                double listWeight = this.list.getWeight(i);
                int listSlidePos = this.weightToPos(listWeight);
                if (listSlidePos == slider.getValue()) break;
                this.weightUpdated(i, this.posToWeight(slider.getValue()));
                break;
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.setCombo && this.setCombo.getSelectedIndex() > 0) {
            Object selected = this.setCombo.getSelectedItem();
            if (SET_NORMALIZED.equals(selected)) {
                this.list.normalize();
            } else if (SET_EQUAL.equals(selected)) {
                this.list.setWeightsEqual();
            } else if (SET_ZERO.equals(selected)) {
                this.list.setWeightsToConstant(0.0);
            } else if (SET_ONE.equals(selected)) {
                this.list.setWeightsToConstant(1.0);
            }
            this.updateSliders();
            this.setCombo.setSelectedIndex(0);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (JSlider slider : this.sliders) {
            slider.setEnabled(false);
        }
        for (JTextField field : this.textFields) {
            field.setEnabled(false);
        }
        super.setEnabled(enabled);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.textUpdated(e.getComponent());
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.textUpdated(e.getComponent());
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void resetText(int i) {
        this.textFields.get(i).setText(df.format(this.list.getWeight(i)));
    }

    private void textUpdated(Component comp) {
        for (int i = 0; i < this.textFields.size(); ++i) {
            JTextField field = this.textFields.get(i);
            if (field != comp) continue;
            try {
                double weight = Double.parseDouble(field.getText());
                if (!this.list.isWeightWithinRange(weight)) {
                    this.resetText(i);
                    continue;
                }
                this.weightUpdated(i, weight);
                continue;
            }
            catch (NumberFormatException e) {
                this.resetText(i);
            }
        }
    }
}

