/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.beans;

import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Region;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.impl.DoubleParameter;

public class GriddedRegionGUIBean
extends ParameterListEditor {
    private static final String MIN_LAT_PARAM_NAME = "Min Lat";
    private static final String MAX_LAT_PARAM_NAME = "Max Lat";
    private static final String MIN_LON_PARAM_NAME = "Min Lon";
    private static final String MAX_LON_PARAM_NAME = "Max Lon";
    private static final String GRIDSPACING_PARAM_NAME = "GridSpacing";
    private DoubleParameter minLatParam;
    private DoubleParameter maxLatParam;
    private DoubleParameter minLonParam;
    private DoubleParameter maxLonParam;
    private DoubleParameter gridSpacingParam;

    public GriddedRegionGUIBean() {
        this(32.0, 36.0, -121.0, -115.0, 0.1);
    }

    public GriddedRegionGUIBean(double minLat, double maxLat, double minLon, double maxLon, double gridSpacing) {
        DoubleConstraint latConst = new DoubleConstraint(-90.0, 90.0);
        DoubleConstraint lonConst = new DoubleConstraint(-180.0, 180.0);
        this.minLatParam = new DoubleParameter(MIN_LAT_PARAM_NAME, latConst, (Double)minLat);
        this.maxLatParam = new DoubleParameter(MAX_LAT_PARAM_NAME, latConst, (Double)maxLat);
        this.minLonParam = new DoubleParameter(MIN_LON_PARAM_NAME, lonConst, (Double)minLon);
        this.maxLonParam = new DoubleParameter(MAX_LON_PARAM_NAME, lonConst, (Double)maxLon);
        DoubleConstraint spacingConst = new DoubleConstraint(0.001, 5.0);
        this.gridSpacingParam = new DoubleParameter(GRIDSPACING_PARAM_NAME, spacingConst, (Double)gridSpacing);
        this.parameterList = new ParameterList();
        this.parameterList.addParameter(this.minLatParam);
        this.parameterList.addParameter(this.maxLatParam);
        this.parameterList.addParameter(this.minLonParam);
        this.parameterList.addParameter(this.maxLonParam);
        this.parameterList.addParameter(this.gridSpacingParam);
        this.setTitle("Select Region");
        this.addParameters();
    }

    public double getMinLat() {
        return (Double)this.minLatParam.getValue();
    }

    public double getMaxLat() {
        return (Double)this.maxLatParam.getValue();
    }

    public double getMinLon() {
        return (Double)this.minLonParam.getValue();
    }

    public double getMaxLon() {
        return (Double)this.maxLonParam.getValue();
    }

    public double getGridSpacing() {
        return (Double)this.gridSpacingParam.getValue();
    }

    public void setFromGriddedRegion(GriddedRegion region) {
        this.setFromGeographicRegion(region);
        this.gridSpacingParam.setValue(region.getSpacing());
    }

    public void setFromGeographicRegion(Region region) {
        this.minLatParam.setValue(region.getMinLat());
        this.maxLatParam.setValue(region.getMaxLat());
        this.minLonParam.setValue(region.getMinLon());
        this.maxLonParam.setValue(region.getMaxLon());
    }
}

