/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jfree.data.Range;
import org.opensha.commons.gui.plot.GraphWidget;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotElement;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotPreferences;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileNameUtils;
import org.opensha.commons.util.FileUtils;

public class GraphWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private List<GraphWidget> widgets;
    private JPanel mainPanel;
    private JTabbedPane widgetTabPane;
    protected JMenuBar menuBar = new JMenuBar();
    protected JMenu fileMenu = new JMenu();
    protected JMenuItem fileExitMenu = new JMenuItem();
    protected JMenuItem fileSaveMenu = new JMenuItem();
    protected JMenuItem fileSaveAllMenu = new JMenuItem();
    protected JMenuItem filePrintMenu = new JCheckBoxMenuItem();
    protected JToolBar jToolBar = new JToolBar();
    protected JButton closeButton = new JButton();
    protected ImageIcon closeFileImage = new ImageIcon(FileUtils.loadImage("icons/closeFile.png"));
    protected JButton printButton = new JButton();
    protected ImageIcon printFileImage = new ImageIcon(FileUtils.loadImage("icons/printFile.jpg"));
    protected JButton saveButton = new JButton();
    protected ImageIcon saveFileImage = new ImageIcon(FileUtils.loadImage("icons/saveFile.jpg"));
    protected static int windowNumber = 1;
    protected static final String TITLE = "Plot Window - ";
    private static final PlotCurveCharacterstics PLOT_CHAR1 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE);
    private static final PlotCurveCharacterstics PLOT_CHAR2 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK);
    private static final PlotCurveCharacterstics PLOT_CHAR3 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN);
    private static final PlotCurveCharacterstics PLOT_CHAR4 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.MAGENTA);
    private static final PlotCurveCharacterstics PLOT_CHAR5 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.PINK);
    private static final PlotCurveCharacterstics PLOT_CHAR6 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.LIGHT_GRAY);
    private static final PlotCurveCharacterstics PLOT_CHAR7 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED);
    private static final PlotCurveCharacterstics PLOT_CHAR8 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.ORANGE);
    private static final PlotCurveCharacterstics PLOT_CHAR9 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.CYAN);
    private static final PlotCurveCharacterstics PLOT_CHAR10 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.DARK_GRAY);
    private static final PlotCurveCharacterstics PLOT_CHAR11 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GRAY);

    public GraphWindow(PlotElement elem, String plotTitle) {
        this(Lists.newArrayList((Object[])new PlotElement[]{elem}), plotTitle);
    }

    public GraphWindow(PlotElement elem, String plotTitle, PlotCurveCharacterstics plotChar) {
        this(Lists.newArrayList((Object[])new PlotElement[]{elem}), plotTitle, Lists.newArrayList((Object[])new PlotCurveCharacterstics[]{plotChar}));
    }

    public GraphWindow(List<? extends PlotElement> elems, String plotTitle) {
        this(elems, plotTitle, GraphWindow.generateDefaultChars(elems));
    }

    public GraphWindow(List<? extends PlotElement> elems, String plotTitle, List<PlotCurveCharacterstics> chars) {
        this(new PlotSpec(elems, chars, plotTitle, null, null));
    }

    public GraphWindow(List<? extends PlotElement> elems, String plotTitle, List<PlotCurveCharacterstics> chars, boolean display) {
        this(new GraphWidget(new PlotSpec(elems, chars, plotTitle, null, null)), display);
    }

    public GraphWindow(PlotSpec spec) {
        this(spec, true);
    }

    public GraphWindow(PlotSpec spec, boolean display) {
        this(new GraphWidget(spec), display);
    }

    public GraphWindow(PlotSpec plotSpec, Range xRange, Range yRange) {
        this(plotSpec, null, false, false, xRange, yRange);
    }

    public GraphWindow(PlotSpec plotSpec, PlotPreferences plotPrefs, boolean xLog, boolean yLog, Range xRange, Range yRange) {
        this(new GraphWidget(plotSpec, plotPrefs, xLog, yLog, xRange, yRange));
    }

    public GraphWindow(GraphWidget widget) {
        this(widget, true);
    }

    public GraphWindow(GraphWidget widget, final boolean display) {
        this.mainPanel = new JPanel(new BorderLayout());
        this.widgets = Lists.newArrayList();
        this.addTab(widget);
        this.fileMenu.setText("File");
        this.fileExitMenu.setText("Exit");
        this.fileSaveMenu.setText("Save");
        this.fileSaveAllMenu.setText("Save All");
        this.filePrintMenu.setText("Print");
        this.fileExitMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphWindow.this.fileExitMenu_actionPerformed(e);
            }
        });
        this.fileSaveMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphWindow.this.fileSaveMenu_actionPerformed(e);
            }
        });
        this.fileSaveAllMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphWindow.this.fileSaveAllMenu_actionPerformed(e);
            }
        });
        this.filePrintMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphWindow.this.filePrintMenu_actionPerformed(e);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphWindow.this.closeButton_actionPerformed(actionEvent);
            }
        });
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphWindow.this.printButton_actionPerformed(actionEvent);
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphWindow.this.saveButton_actionPerformed(actionEvent);
            }
        });
        this.menuBar.add(this.fileMenu);
        this.fileMenu.add(this.fileSaveMenu);
        this.fileMenu.add(this.fileSaveAllMenu);
        this.fileMenu.add(this.filePrintMenu);
        this.fileMenu.add(this.fileExitMenu);
        this.setJMenuBar(this.menuBar);
        this.closeButton.setIcon(this.closeFileImage);
        this.closeButton.setToolTipText("Close Window");
        Dimension d = this.closeButton.getSize();
        this.jToolBar.add(this.closeButton);
        this.printButton.setIcon(this.printFileImage);
        this.printButton.setToolTipText("Print Graph");
        this.printButton.setSize(d);
        this.jToolBar.add(this.printButton);
        this.saveButton.setIcon(this.saveFileImage);
        this.saveButton.setToolTipText("Save Graph as image");
        this.saveButton.setSize(d);
        this.jToolBar.add(this.saveButton);
        this.jToolBar.setFloatable(false);
        this.mainPanel.add((Component)this.jToolBar, "North");
        this.mainPanel.add((Component)widget, "Center");
        this.setContentPane(this.mainPanel);
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.setTitle(GraphWindow.TITLE + windowNumber++);
                this.this$0.setSize(700, 800);
                if (display) {
                    this.this$0.setVisible(true);
                }
            }
        });
    }

    public void setX_AxisLabel(final String xAxisLabel) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setXAxisLabel(xAxisLabel);
            }
        });
    }

    public void setY_AxisLabel(final String yAxisLabel) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setYAxisLabel(yAxisLabel);
            }
        });
    }

    public void addTab(PlotSpec spec) {
        this.addTab(new GraphWidget(spec));
    }

    public void addTab(GraphWidget widget) {
        String title;
        Preconditions.checkState((!this.widgets.contains(widget) ? 1 : 0) != 0);
        if (this.widgets.size() == 1 && this.widgetTabPane == null) {
            this.widgetTabPane = new JTabbedPane();
            this.mainPanel.remove(this.widgets.get(0));
            title = this.widgets.get(0).getPlotSpec().getTitle();
            if (title == null || title.isEmpty()) {
                title = "(no title)";
            }
            this.widgetTabPane.addTab(title, this.widgets.get(0));
            this.mainPanel.add((Component)this.widgetTabPane, "Center");
        }
        this.widgets.add(widget);
        if (this.widgets.size() > 1) {
            title = widget.getPlotSpec().getTitle();
            if (title == null || title.isEmpty()) {
                title = "(no title)";
            }
            this.widgetTabPane.addTab(title, widget);
            Preconditions.checkState((this.widgetTabPane.getTabCount() == this.widgets.size() ? 1 : 0) != 0);
            this.widgetTabPane.setSelectedIndex(this.widgets.size() - 1);
        }
    }

    public void setSelectedTab(final int index) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.widgetTabPane.setSelectedIndex(index);
            }
        });
    }

    public GraphWidget getGraphWidget() {
        if (this.widgetTabPane == null) {
            return this.widgets.get(0);
        }
        return this.widgets.get(this.widgetTabPane.getSelectedIndex());
    }

    protected static ArrayList<PlotCurveCharacterstics> generateDefaultChars(List<? extends PlotElement> elems) {
        ArrayList<PlotCurveCharacterstics> list = new ArrayList<PlotCurveCharacterstics>();
        list.add(PLOT_CHAR1);
        list.add(PLOT_CHAR2);
        list.add(PLOT_CHAR3);
        list.add(PLOT_CHAR4);
        list.add(PLOT_CHAR5);
        list.add(PLOT_CHAR6);
        list.add(PLOT_CHAR7);
        list.add(PLOT_CHAR8);
        list.add(PLOT_CHAR9);
        list.add(PLOT_CHAR10);
        list.add(PLOT_CHAR11);
        if (elems == null) {
            return list;
        }
        int numChars = list.size();
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        for (int i = 0; i < elems.size(); ++i) {
            plotChars.add(list.get(i % numChars));
        }
        return plotChars;
    }

    public static List<Color> generateDefaultColors() {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (PlotCurveCharacterstics pchar : GraphWindow.generateDefaultChars(null)) {
            colors.add(pchar.getColor());
        }
        return colors;
    }

    protected void fileExitMenu_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    protected void fileSaveMenu_actionPerformed(ActionEvent actionEvent) {
        try {
            this.getGraphWidget().save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    protected void fileSaveAllMenu_actionPerformed(ActionEvent actionEvent) {
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            int option = chooser.showSaveDialog(this);
            if (option == 0) {
                File dir = chooser.getSelectedFile();
                for (GraphWidget widget : this.widgets) {
                    String title = widget.getPlotLabel();
                    String fname = FileNameUtils.simplify(title);
                    String prefix = new File(dir, fname).getAbsolutePath();
                    widget.saveAsPNG(prefix + ".png");
                    widget.saveAsPDF(prefix + ".pdf");
                    widget.saveAsTXT(prefix + ".txt");
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    protected void filePrintMenu_actionPerformed(ActionEvent actionEvent) {
        this.getGraphWidget().print();
    }

    protected void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    protected void printButton_actionPerformed(ActionEvent actionEvent) {
        this.getGraphWidget().print();
    }

    protected void saveButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.getGraphWidget().save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    public void saveAsPDF(final String fileName) throws IOException {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.getGraphWidget().saveAsPDF(fileName);
                }
                catch (IOException e) {
                    ExceptionUtils.throwAsRuntimeException(e);
                }
            }
        });
    }

    public void saveAsPNG(final String fileName) throws IOException {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.getGraphWidget().saveAsPNG(fileName);
                }
                catch (IOException e) {
                    ExceptionUtils.throwAsRuntimeException(e);
                }
            }
        });
    }

    public void saveAsTXT(String fileName) throws IOException {
        this.getGraphWidget().saveAsTXT(fileName);
    }

    public void setXLog(final boolean xLog) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setX_Log(xLog);
            }
        });
    }

    public void setYLog(final boolean yLog) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setY_Log(yLog);
            }
        });
    }

    public void setAxisRange(final double xMin, final double xMax, final double yMin, final double yMax) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setAxisRange(xMin, xMax, yMin, yMax);
            }
        });
    }

    public void setAxisRange(final Range xRange, final Range yRange) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setAxisRange(xRange, yRange);
            }
        });
    }

    public void setPlotSpec(final PlotSpec plotSpec) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setPlotSpec(plotSpec);
            }
        });
    }

    public void setPlotChars(final List<PlotCurveCharacterstics> curveCharacteristics) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setPlotChars(curveCharacteristics);
            }
        });
    }

    public void togglePlot() {
        GraphWindow.doGUIThreadSafe(new Runnable(){

            @Override
            public void run() {
                GraphWindow.this.getGraphWidget().togglePlot();
            }
        });
    }

    public void setPlotLabel(final String plotTitle) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setPlotLabel(plotTitle);
            }
        });
    }

    public void setPlotLabelFontSize(final int fontSize) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setPlotLabelFontSize(fontSize);
            }
        });
    }

    public void setTickLabelFontSize(final int fontSize) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setTickLabelFontSize(fontSize);
            }
        });
    }

    public void setAxisLabelFontSize(final int fontSize) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setAxisLabelFontSize(fontSize);
            }
        });
    }

    public void setX_AxisRange(final double minX, final double maxX) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setX_AxisRange(minX, maxX);
            }
        });
    }

    public void setX_AxisRange(final Range xRange) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setX_AxisRange(xRange);
            }
        });
    }

    public Range getX_AxisRange() {
        return this.getGraphWidget().getX_AxisRange();
    }

    public void setY_AxisRange(final double minY, final double maxY) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setY_AxisRange(minY, maxY);
            }
        });
    }

    public void setY_AxisRange(final Range yRange) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setY_AxisRange(yRange);
            }
        });
    }

    public Range getY_AxisRange() {
        return this.getGraphWidget().getY_AxisRange();
    }

    public void setAllLineTypes(final PlotLineType line, final PlotSymbol symbol) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                for (PlotCurveCharacterstics pchar : this.this$0.getGraphWidget().getPlottingFeatures()) {
                    pchar.setLineType(line);
                    pchar.setSymbol(symbol);
                }
            }
        });
    }

    public void setAutoRange() {
        GraphWindow.doGUIThreadSafe(new Runnable(){

            @Override
            public void run() {
                GraphWindow.this.getGraphWidget().setAutoRange();
            }
        });
    }

    public void setGriddedFuncAxesTicks(final boolean histogramAxesTicks) {
        GraphWindow.doGUIThreadSafe(new Runnable(){
            final /* synthetic */ GraphWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getGraphWidget().setGriddedFuncAxesTicks(histogramAxesTicks);
            }
        });
    }

    public void redrawGraph() {
        GraphWindow.doGUIThreadSafe(new Runnable(){

            @Override
            public void run() {
                GraphWindow.this.getGraphWidget().drawGraph();
            }
        });
    }

    private static void doGUIThreadSafe(Runnable run) {
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (Exception e1) {
                ExceptionUtils.throwAsRuntimeException(e1);
            }
        }
    }
}

