/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlotPreferences {
    private int axisLabelFontSize;
    private int tickLabelFontSize;
    private int plotLabelFontSize;
    private int legendFontSize;
    private Color backgroundColor;
    private Color insetLegendBackground = new Color(255, 255, 255, 180);
    private Color insetLegendBorder = Color.BLACK;
    private List<ChangeListener> listeners = Lists.newArrayList();

    public static PlotPreferences getDefault() {
        PlotPreferences pref = new PlotPreferences();
        pref.tickLabelFontSize = 12;
        pref.axisLabelFontSize = 14;
        pref.plotLabelFontSize = 16;
        pref.legendFontSize = 14;
        pref.backgroundColor = new Color(200, 200, 230);
        return pref;
    }

    private PlotPreferences() {
    }

    public int getAxisLabelFontSize() {
        return this.axisLabelFontSize;
    }

    public void setAxisLabelFontSize(int axisLabelFontSize) {
        this.axisLabelFontSize = axisLabelFontSize;
        this.fireChangeEvent();
    }

    public int getTickLabelFontSize() {
        return this.tickLabelFontSize;
    }

    public void setTickLabelFontSize(int tickLabelFontSize) {
        this.tickLabelFontSize = tickLabelFontSize;
        this.fireChangeEvent();
    }

    public int getPlotLabelFontSize() {
        return this.plotLabelFontSize;
    }

    public void setPlotLabelFontSize(int plotLabelFontSize) {
        this.plotLabelFontSize = plotLabelFontSize;
        this.fireChangeEvent();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.fireChangeEvent();
    }

    public int getLegendFontSize() {
        return this.legendFontSize;
    }

    public void setLegendFontSize(int legendFontSize) {
        this.legendFontSize = legendFontSize;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public boolean removeChangeListener(ChangeListener l) {
        return this.listeners.remove(l);
    }

    private void fireChangeEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    public Color getInsetLegendBackground() {
        return this.insetLegendBackground;
    }

    public void setInsetLegendBackground(Color insetLegendBackground) {
        this.insetLegendBackground = insetLegendBackground;
    }

    public Color getInsetLegendBorder() {
        return this.insetLegendBorder;
    }

    public void setInsetLegendBorder(Color insetLegendBorder) {
        this.insetLegendBorder = insetLegendBorder;
    }

    public void scaleFontSizes(double scalar) {
        this.axisLabelFontSize = (int)((double)this.axisLabelFontSize * scalar + 0.5);
        this.tickLabelFontSize = (int)((double)this.tickLabelFontSize * scalar + 0.5);
        this.plotLabelFontSize = (int)((double)this.plotLabelFontSize * scalar + 0.5);
        this.legendFontSize = (int)((double)this.legendFontSize * scalar + 0.5);
    }

    public PlotPreferences clone() {
        PlotPreferences ret = new PlotPreferences();
        ret.axisLabelFontSize = this.axisLabelFontSize;
        ret.tickLabelFontSize = this.tickLabelFontSize;
        ret.plotLabelFontSize = this.plotLabelFontSize;
        ret.legendFontSize = this.legendFontSize;
        ret.backgroundColor = this.backgroundColor;
        ret.insetLegendBackground = this.insetLegendBackground;
        ret.insetLegendBorder = this.insetLegendBorder;
        return ret;
    }
}

