/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot.jfreechart;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.Range;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;

public class CustomOffsetNumberAxis
extends NumberAxis {
    private static final long serialVersionUID = 1L;
    private double centerPoint;
    private double delta;
    private static final double LOG_2 = Math.log(2.0);
    private Range prevRange;
    private double[] tickVals;
    private double prevTickDelta;

    public CustomOffsetNumberAxis(EvenlyDiscretizedFunc func, String label) {
        this(func.getMinX(), func.getDelta(), label);
    }

    public CustomOffsetNumberAxis(double centerPoint, double delta, String label) {
        super(label);
        Preconditions.checkState((boolean)Doubles.isFinite((double)centerPoint));
        Preconditions.checkState((boolean)Doubles.isFinite((double)delta));
        Preconditions.checkState((delta > 0.0 ? 1 : 0) != 0);
        this.centerPoint = centerPoint;
        this.delta = delta;
        this.setStandardTickUnits(new TickUnitSourceImpl());
    }

    protected double calculateLowestVisibleTickValue() {
        double[] vals = this.getTickValsInRange();
        Preconditions.checkState((vals.length > 0 ? 1 : 0) != 0, (Object)"no vals indices in range!");
        return vals[0];
    }

    protected double calculateHighestVisibleTickValue() {
        double[] vals = this.getTickValsInRange();
        Preconditions.checkState((vals.length > 0 ? 1 : 0) != 0, (Object)"no vals indices in range!");
        return vals[vals.length - 1];
    }

    protected int calculateVisibleTickCount() {
        return this.getTickValsInRange().length;
    }

    private synchronized double[] getTickValsInRange() {
        return this.getTickValsInRange(this.getTickUnit().getSize());
    }

    private synchronized double[] getTickValsInRange(double tickDelta) {
        Range range = this.getRange();
        if (this.prevRange != null && range.getLowerBound() == this.prevRange.getLowerBound() && range.getUpperBound() == this.prevRange.getUpperBound() && this.prevTickDelta == tickDelta) {
            return this.tickVals;
        }
        double lower = range.getLowerBound();
        double upper = range.getUpperBound();
        double lowerNumAwayCenter = Math.floor((lower - this.centerPoint) / tickDelta);
        double startLower = this.centerPoint + lowerNumAwayCenter * tickDelta;
        Preconditions.checkState((startLower <= lower ? 1 : 0) != 0);
        ArrayList vals = Lists.newArrayList();
        for (double val = startLower; val <= upper; val += tickDelta) {
            if (val < lower) continue;
            vals.add(val);
        }
        double[] ret = Doubles.toArray((Collection)vals);
        this.tickVals = ret;
        this.prevRange = new Range(range.getLowerBound(), range.getUpperBound());
        this.prevTickDelta = tickDelta;
        return ret;
    }

    protected double estimateMaximumTickLabelWidth(Graphics2D g2, TickUnit unit) {
        RectangleInsets tickLabelInsets = this.getTickLabelInsets();
        double result = tickLabelInsets.getLeft() + tickLabelInsets.getRight();
        if (this.isVerticalTickLabels()) {
            FontRenderContext frc = g2.getFontRenderContext();
            LineMetrics lm = this.getTickLabelFont().getLineMetrics("0", frc);
            result += (double)lm.getHeight();
        } else {
            FontMetrics fm = g2.getFontMetrics(this.getTickLabelFont());
            double[] tickVals = this.getTickValsInRange();
            double lower = tickVals[0];
            double upper = tickVals[tickVals.length - 1];
            String lowerStr = "";
            String upperStr = "";
            NumberFormat formatter = this.getNumberFormatOverride();
            if (formatter != null) {
                lowerStr = formatter.format(lower);
                upperStr = formatter.format(upper);
            } else {
                lowerStr = unit.valueToString(lower);
                upperStr = unit.valueToString(upper);
            }
            double w1 = fm.stringWidth(lowerStr);
            double w2 = fm.stringWidth(upperStr);
            result += Math.max(w1, w2);
        }
        return result;
    }

    public static void main(String[] args) {
        double minX = -7.82;
        double delta = 1.5;
        int num = 15;
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(minX, num, delta);
        for (int i = 0; i < func.size(); ++i) {
            func.set(i, Math.random());
        }
        GraphWindow gw = new GraphWindow(func, "Asdf", new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK));
        gw.setGriddedFuncAxesTicks(true);
        gw.setDefaultCloseOperation(3);
    }

    private class TickUnitSourceImpl
    implements TickUnitSource {
        private TickUnitSourceImpl() {
        }

        public TickUnit getCeilingTickUnit(TickUnit unit) {
            return this.getCeilingTickUnit(unit.getSize());
        }

        public TickUnit getCeilingTickUnit(double size) {
            double log = Math.log(size / CustomOffsetNumberAxis.this.delta) / LOG_2;
            double higher = Math.ceil(log);
            double ret = CustomOffsetNumberAxis.this.delta * Math.pow(2.0, higher);
            Preconditions.checkState((ret >= size ? 1 : 0) != 0);
            return new NumberTickUnit(ret);
        }

        public TickUnit getLargerTickUnit(TickUnit unit) {
            double x = unit.getSize();
            double log = Math.log(x / CustomOffsetNumberAxis.this.delta) / LOG_2;
            double higher = Math.ceil(log);
            double ret = CustomOffsetNumberAxis.this.delta * Math.pow(2.0, higher);
            Preconditions.checkState((ret >= x ? 1 : 0) != 0);
            if (ret == x) {
                ret = CustomOffsetNumberAxis.this.delta * Math.pow(2.0, higher + 1.0);
            }
            return new NumberTickUnit(ret);
        }
    }
}

