/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot.jfreechart;

import com.google.common.base.Preconditions;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.ui.RectangleEdge;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.PaintScaleWrapper;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;

public class PixelSpacePaintScaleLegend
extends PaintScaleLegend {
    private PaintScaleWrapper scale;
    private ValueAxis axis;
    private double pixelsPerSpan;
    private static double OVERSHOOT_PIXELS = 1.0;

    public PixelSpacePaintScaleLegend(PaintScaleWrapper scale, ValueAxis axis, double pixelsPerSpan) {
        super((PaintScale)scale, axis);
        this.scale = scale;
        this.axis = axis;
        this.pixelsPerSpan = pixelsPerSpan;
    }

    public Object draw(Graphics2D g2, Rectangle2D area, Object params) {
        RectangleEdge axisEdge;
        Paint backgroundPaint = this.getBackgroundPaint();
        AxisLocation axisLocation = this.getAxisLocation();
        double stripWidth = this.getStripWidth();
        Paint stripOutlinePaint = this.getStripOutlinePaint();
        Stroke stripOutlineStroke = this.getStripOutlineStroke();
        double axisOffset = this.getAxisOffset();
        Rectangle2D target = (Rectangle2D)area.clone();
        target = this.trimMargin(target);
        if (backgroundPaint != null) {
            g2.setPaint(backgroundPaint);
            g2.fill(target);
        }
        this.getFrame().draw(g2, target);
        this.getFrame().getInsets().trim(target);
        target = this.trimPadding(target);
        double lower = this.axis.getLowerBound();
        double upper = this.axis.getUpperBound();
        Preconditions.checkState((upper > lower ? 1 : 0) != 0, (Object)"Axis bound upper must be > lower");
        Rectangle2D.Double r = new Rectangle2D.Double();
        boolean discrete = true;
        CPT cpt = this.scale.getCPT();
        for (CPTVal val : cpt) {
            if (val.minColor.equals(val.maxColor)) continue;
            discrete = false;
            break;
        }
        if (RectangleEdge.isTopOrBottom((RectangleEdge)this.getPosition())) {
            double axisY;
            double stripY;
            axisEdge = Plot.resolveRangeAxisLocation((AxisLocation)axisLocation, (PlotOrientation)PlotOrientation.HORIZONTAL);
            double totalW = target.getWidth();
            if (axisEdge == RectangleEdge.TOP) {
                stripY = target.getMaxY() - stripWidth;
                axisY = target.getMaxY() - stripWidth - axisOffset;
            } else {
                stripY = target.getMinY();
                axisY = target.getMinY() + stripWidth + axisOffset;
            }
            if (discrete) {
                for (int i = 0; i < cpt.size(); ++i) {
                    CPTVal val = (CPTVal)cpt.get(i);
                    double startVal = val.start;
                    double endVal = val.end;
                    if (startVal == endVal) continue;
                    if (cpt.isLog10()) {
                        startVal = Math.pow(10.0, startVal);
                        endVal = Math.pow(10.0, endVal);
                    }
                    double start = this.axis.valueToJava2D(startVal, target, axisEdge);
                    double end = this.axis.valueToJava2D(endVal, target, axisEdge);
                    if (i < cpt.size() - 1) {
                        end += OVERSHOOT_PIXELS;
                    }
                    double width = end - start;
                    ((Rectangle2D)r).setRect(start, stripY, width, stripWidth);
                    g2.setPaint(val.minColor);
                    g2.fill(r);
                }
            } else {
                int subdivisions = (int)Math.round(totalW / this.pixelsPerSpan);
                if (subdivisions < 10) {
                    subdivisions = 10;
                }
                double fullSpan = totalW / (double)subdivisions;
                double halfSpan = 0.5 * fullSpan;
                for (int i = 0; i < subdivisions; ++i) {
                    double start = target.getMinX() + (double)i * fullSpan;
                    double middle = start + halfSpan;
                    double width = fullSpan;
                    if (i < subdivisions - 1) {
                        width += OVERSHOOT_PIXELS;
                    }
                    double scaleValue = this.axis.java2DToValue(middle, target, axisEdge);
                    ((Rectangle2D)r).setRect(start, stripY, width, stripWidth);
                    g2.setPaint(this.scale.getPaint(scaleValue));
                    g2.fill(r);
                }
            }
            if (this.isStripOutlineVisible()) {
                g2.setPaint(stripOutlinePaint);
                g2.setStroke(stripOutlineStroke);
                g2.draw(new Rectangle2D.Double(target.getMinX(), stripY, target.getWidth(), stripWidth));
            }
            this.axis.draw(g2, axisY, target, target, axisEdge, null);
        } else {
            double axisX;
            double stripX;
            axisEdge = Plot.resolveRangeAxisLocation((AxisLocation)axisLocation, (PlotOrientation)PlotOrientation.VERTICAL);
            if (axisEdge == RectangleEdge.LEFT) {
                stripX = target.getMaxX() - stripWidth;
                axisX = target.getMaxX() - stripWidth - axisOffset;
            } else {
                stripX = target.getMinX();
                axisX = target.getMinX() + stripWidth + axisOffset;
            }
            if (discrete) {
                for (int i = 0; i < cpt.size(); ++i) {
                    CPTVal val = (CPTVal)cpt.get(i);
                    double startVal = val.start;
                    double endVal = val.end;
                    if (startVal == endVal) continue;
                    if (cpt.isLog10()) {
                        startVal = Math.pow(10.0, startVal);
                        endVal = Math.pow(10.0, endVal);
                    }
                    double start = this.axis.valueToJava2D(startVal, target, axisEdge);
                    double end = this.axis.valueToJava2D(endVal, target, axisEdge);
                    if (i < cpt.size() - 1) {
                        end -= OVERSHOOT_PIXELS;
                    }
                    double height = start - end;
                    ((Rectangle2D)r).setRect(stripX, end, stripWidth, height);
                    g2.setPaint(val.minColor);
                    g2.fill(r);
                }
            } else {
                double totalH = target.getHeight();
                int subdivisions = (int)Math.round(totalH / this.pixelsPerSpan);
                if (subdivisions < 10) {
                    subdivisions = 10;
                }
                double fullSpan = totalH / (double)subdivisions;
                double halfSpan = 0.5 * fullSpan;
                for (int i = 0; i < subdivisions; ++i) {
                    double start = target.getMinY() + (double)i * fullSpan;
                    double middle = start + halfSpan;
                    double height = fullSpan;
                    if (i < subdivisions - 1) {
                        height += OVERSHOOT_PIXELS;
                    }
                    double scaleValue = this.axis.java2DToValue(middle, target, axisEdge);
                    ((Rectangle2D)r).setRect(stripX, start, stripWidth, height);
                    g2.setPaint(this.scale.getPaint(scaleValue));
                    g2.fill(r);
                }
            }
            if (this.isStripOutlineVisible()) {
                g2.setPaint(stripOutlinePaint);
                g2.setStroke(stripOutlineStroke);
                g2.draw(new Rectangle2D.Double(stripX, target.getMinY(), stripWidth, target.getHeight()));
            }
            this.axis.draw(g2, axisX, target, target, axisEdge, null);
        }
        return null;
    }
}

