/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot.pdf;

import com.google.common.base.Preconditions;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.pdf.BaseFont;
import java.awt.Font;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class PDF_UTF8_FontMapper
implements FontMapper {
    private HashMap<String, String> aliases = new HashMap();
    private HashMap<String, BaseFontParameters> mapper = new HashMap();
    private static final String SANS_BASE = "Arimo";
    public static final String SANS = "Arimo-Regular";
    public static final String SANS_BOLD = "Arimo-Bold";
    public static final String SANS_BOLD_ITALIC = "Arimo-BoldItalic";
    public static final String SANS_ITALIC = "Arimo-Italic";
    private static final String MONO_BASE = "Cousine";
    public static final String MONO = "Cousine-Regular";
    public static final String MONO_BOLD = "Cousine-Bold";
    public static final String MONO_BOLD_ITALIC = "Cousine-BoldItalic";
    public static final String MONO_ITALIC = "Cousine-Italic";
    private static final String SERIF_BASE = "Tinos";
    public static final String SERIF = "Tinos-Regular";
    public static final String SERIF_BOLD = "Tinos-Bold";
    public static final String SERIF_BOLD_ITALIC = "Tinos-BoldItalic";
    public static final String SERIF_ITALIC = "Tinos-Italic";
    private static final Map<String, String> fontPaths;

    public BaseFont awtToPdf(Font font) {
        try {
            BaseFont ret;
            BaseFontParameters p = this.getBaseFontParameters(font.getFontName());
            if (p != null) {
                return BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, (byte[])p.ttfAfm, (byte[])p.pfb);
            }
            String fontKey = null;
            String logicalName = font.getName();
            fontKey = logicalName.equalsIgnoreCase("DialogInput") || logicalName.equalsIgnoreCase("Monospaced") || logicalName.equalsIgnoreCase("Courier") ? (font.isItalic() ? (font.isBold() ? MONO_BOLD_ITALIC : MONO_ITALIC) : (font.isBold() ? MONO_BOLD : MONO)) : (logicalName.equalsIgnoreCase("Serif") || logicalName.equalsIgnoreCase("TimesRoman") ? (font.isItalic() ? (font.isBold() ? SERIF_BOLD_ITALIC : SERIF_ITALIC) : (font.isBold() ? SERIF_BOLD : SERIF)) : (font.isItalic() ? (font.isBold() ? SANS_BOLD_ITALIC : SANS_ITALIC) : (font.isBold() ? SANS_BOLD : SANS)));
            Preconditions.checkState((boolean)fontPaths.containsKey(fontKey));
            fontKey = fontPaths.get(fontKey);
            try {
                ret = BaseFont.createFont((String)fontKey, (String)"Identity-H", (boolean)true);
            }
            catch (Exception e) {
                System.err.println("WARNING: failed to create unicode compatible font with key=" + fontKey);
                e.printStackTrace();
                ret = BaseFont.createFont((String)fontKey, (String)"Cp1252", (boolean)false);
            }
            return ret;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public Font pdfToAwt(BaseFont font, int size) {
        String finalName;
        String[][] names = font.getFullFontName();
        if (names.length == 1) {
            return new Font(names[0][3], 0, size);
        }
        String name10 = null;
        String name3x = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if (name[0].equals("1") && name[1].equals("0")) {
                name10 = name[3];
                continue;
            }
            if (!name[2].equals("1033")) continue;
            name3x = name[3];
            break;
        }
        if ((finalName = name3x) == null) {
            finalName = name10;
        }
        if (finalName == null) {
            finalName = names[0][3];
        }
        return new Font(finalName, 0, size);
    }

    public BaseFontParameters getBaseFontParameters(String name) {
        String alias = this.aliases.get(name);
        if (alias == null) {
            return this.mapper.get(name);
        }
        BaseFontParameters p = this.mapper.get(alias);
        if (p == null) {
            return this.mapper.get(name);
        }
        return p;
    }

    static {
        String[] all = new String[]{SANS, SANS_BOLD, SANS_BOLD_ITALIC, SANS_ITALIC, MONO, MONO_BOLD, MONO_BOLD_ITALIC, MONO_ITALIC, SERIF, SERIF_BOLD, SERIF_BOLD_ITALIC, SERIF_ITALIC};
        fontPaths = new HashMap<String, String>();
        for (String name : all) {
            String path = "/fonts/croscore/" + name + ".ttf";
            URL resource = PDF_UTF8_FontMapper.class.getResource(path);
            Preconditions.checkNotNull((Object)resource, (String)"Resource not found: %s", (Object)path);
            fontPaths.put(name, resource.toString());
            FontFactory.register((String)resource.toString(), (String)name);
        }
    }

    public static class BaseFontParameters {
        public String fontName;
        public String encoding;
        public boolean embedded;
        public boolean cached;
        public byte[] ttfAfm;
        public byte[] pfb;

        public BaseFontParameters(String fontName) {
            this.fontName = fontName;
            this.encoding = "Identity-H";
            this.embedded = true;
            this.cached = true;
        }
    }
}

