/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.hpc;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.opensha.commons.metadata.XMLSaveable;

public class JavaShellScriptWriter
implements XMLSaveable {
    public static final String XML_METADATA_NAME = "JavaShellScriptWriter";
    private File javaBin;
    private int maxHeapSizeMB;
    private int initialHeapSizeMB = -1;
    private Collection<File> classpath;
    private boolean headless;
    private Map<String, String> properties;
    private Map<String, String> envVars;
    private List<String> customSetupLines;
    private int autoMemBufferMB = 5000;
    private boolean autoMemDetect = false;

    public JavaShellScriptWriter(File javaBin, int maxHeapSizeMB, Collection<File> classpath) {
        this.setJavaBin(javaBin);
        this.maxHeapSizeMB = maxHeapSizeMB;
        this.classpath = classpath;
    }

    public File getJavaBin() {
        return this.javaBin;
    }

    public void setJavaBin(File javaBin) {
        Preconditions.checkNotNull((Object)javaBin, (Object)"java binary path cannot be null");
        this.javaBin = javaBin;
    }

    public int getMaxHeapSizeMB() {
        return this.maxHeapSizeMB;
    }

    public void setMaxHeapSizeMB(int maxHeapSizeMB) {
        this.maxHeapSizeMB = maxHeapSizeMB;
    }

    public int getInitialHeapSizeMB() {
        return this.initialHeapSizeMB;
    }

    public void setInitialHeapSizeMB(int initialHeapSizeMB) {
        this.initialHeapSizeMB = initialHeapSizeMB;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public Collection<File> getClasspath() {
        return this.classpath;
    }

    public void setClasspath(Collection<File> classpath) {
        this.classpath = classpath;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public void clearProperty(String key) {
        this.properties.remove(key);
    }

    public void clearProperties() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    public Map<String, String> getEnvVars() {
        return this.envVars;
    }

    public void setEnvVar(String key, String value) {
        if (this.envVars == null) {
            this.envVars = new LinkedHashMap<String, String>();
        }
        this.envVars.put(key, value);
    }

    public void clearEnvVar(String key) {
        this.envVars.remove(key);
    }

    public void clearEnvVars() {
        if (this.envVars != null) {
            this.envVars.clear();
        }
    }

    public void setAutoMemDetect(boolean autoMemDetect) {
        this.autoMemDetect = autoMemDetect;
    }

    public void setCustomSetupLines(List<String> setupLines) {
        this.customSetupLines = setupLines;
    }

    public List<String> getCustomSetupLines() {
        return this.customSetupLines;
    }

    public List<String> getJVMSetupLines() {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.maxHeapSizeMB > 0 || this.autoMemDetect) {
            lines.add("JVM_MEM_MB=" + this.maxHeapSizeMB);
        }
        if (this.initialHeapSizeMB > 0) {
            lines.add("JVM_INITIAL_MEM_MB=" + this.initialHeapSizeMB);
        }
        if (this.autoMemDetect) {
            lines.add("AUTO_MEM_BUFFER_MB=" + this.autoMemBufferMB);
            lines.add("echo \"Minimum JVM memory: $JVM_MEM_MB\"");
            lines.add("# detect system memory");
            lines.add("let MEM=`awk '/MemTotal/{print $2}' /proc/meminfo`");
            lines.add("# convert to MB");
            lines.add("let MEM=$MEM/1024");
            lines.add("echo \"System memory: $MEM MB\"");
            lines.add("let MAXMEM=$MEM-$AUTO_MEM_BUFFER_MB");
            lines.add("echo \"Max auto system memory: $MAXMEM MB\"");
            lines.add("if [[ $MAXMEM -gt $JVM_MEM_MB ]];then");
            lines.add("\tJVM_MEM_MB=$MAXMEM");
            lines.add("\techo \"Increased JVM memory to $JVM_MEM_MB MB\"");
            lines.add("else");
            lines.add("\techo \"Keeping minimum JVM MEM of $JVM_MEM_MB MB\"");
            lines.add("fi");
        }
        return lines;
    }

    public List<String> getAllSetupLines() {
        List<String> jvmLines;
        ArrayList<String> lines = new ArrayList<String>();
        if (this.envVars != null) {
            for (String varName : this.envVars.keySet()) {
                lines.add(varName + "=" + this.envVars.get(varName));
            }
        }
        if (this.customSetupLines != null && !this.customSetupLines.isEmpty()) {
            if (!lines.isEmpty()) {
                lines.add("");
            }
            lines.addAll(this.customSetupLines);
        }
        if ((jvmLines = this.getJVMSetupLines()) != null && !jvmLines.isEmpty()) {
            if (!lines.isEmpty()) {
                lines.add("");
            }
            lines.addAll(jvmLines);
        }
        return lines;
    }

    protected String getJVMArgs(String className) {
        Preconditions.checkNotNull((Object)className, (Object)"class name cannot be null or empty");
        Preconditions.checkArgument((!className.isEmpty() ? 1 : 0) != 0, (Object)"class name cannot be null or empty");
        Object cp = "";
        if (this.classpath != null && !this.classpath.isEmpty()) {
            cp = " -cp ";
            boolean first = true;
            for (File el : this.classpath) {
                if (first) {
                    first = false;
                } else {
                    cp = (String)cp + ":";
                }
                cp = (String)cp + el.getPath();
            }
        }
        Object jvmArgs = "";
        if (this.headless) {
            jvmArgs = " -Djava.awt.headless=true";
        }
        if (this.properties != null) {
            for (String key : this.properties.keySet()) {
                String value = this.properties.get(key);
                Preconditions.checkState((!key.contains(" ") && !value.contains(" ") ? 1 : 0) != 0, (Object)"no spaces allowed in properties!");
                jvmArgs = (String)jvmArgs + " -D" + key + "=" + value;
            }
        }
        if (this.maxHeapSizeMB > 0) {
            jvmArgs = (String)jvmArgs + " -Xmx${JVM_MEM_MB}M";
        }
        if (this.initialHeapSizeMB > 0) {
            jvmArgs = (String)jvmArgs + " -Xms${JVM_INITIAL_MEM_MB}M";
        }
        String args = JavaShellScriptWriter.getFormattedArgs((String)jvmArgs + (String)cp);
        return args + " " + className;
    }

    public String buildCommand(String className, String args) {
        String javaPath = this.javaBin.getPath();
        if (javaPath.contains(File.pathSeparator) && !javaPath.equals("java")) {
            javaPath = this.javaBin.getAbsolutePath();
        }
        String command = javaPath + this.getJVMArgs(className);
        command = command + JavaShellScriptWriter.getFormattedArgs(args);
        return command;
    }

    protected static String getFormattedArgs(String args) {
        if (args != null && !((String)args).isEmpty()) {
            if (!((String)args).startsWith(" ")) {
                args = " " + (String)args;
            }
            return args;
        }
        return "";
    }

    public List<String> buildScript(String className, String args) {
        return this.buildScript(List.of(className), List.of(args));
    }

    public List<String> buildScript(List<String> classNames, List<String> argss) {
        ArrayList<String> script = new ArrayList<String>();
        Preconditions.checkArgument((classNames.size() == argss.size() ? 1 : 0) != 0);
        script.add("#!/bin/bash");
        script.add("");
        script.addAll(this.getAllSetupLines());
        for (int i = 0; i < classNames.size(); ++i) {
            script.add("");
            script.add(this.buildCommand(classNames.get(i), argss.get(i)));
            if (i >= classNames.size() - 1) continue;
            script.add("if [[ $? -ne 0 ]];then");
            script.add("\texit $?");
            script.add("fi");
        }
        script.add("exit $?");
        return script;
    }

    public static void writeScript(File file, List<String> script) throws IOException {
        FileWriter fw = new FileWriter(file);
        for (String line : script) {
            fw.write(line + "\n");
        }
        fw.close();
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element el = root.addElement(XML_METADATA_NAME);
        el.addAttribute("javaBin", this.javaBin.getAbsolutePath());
        el.addAttribute("heapSizeMB", "" + this.maxHeapSizeMB);
        if (this.classpath != null && !this.classpath.isEmpty()) {
            Element cpEl = el.addElement("Classpath");
            for (File cp : this.classpath) {
                Element cpElEl = cpEl.addElement("element");
                cpElEl.addAttribute("path", cp.getAbsolutePath());
            }
        }
        return root;
    }

    public static JavaShellScriptWriter fromXMLMetadata(Element javaEl) {
        File javaBin = new File(javaEl.attributeValue("javaBin"));
        int heapSizeMB = Integer.parseInt(javaEl.attributeValue("heapSizeMB"));
        Element cpEl = javaEl.element("Classpath");
        ArrayList<File> classpath = null;
        if (cpEl != null) {
            Iterator it = cpEl.elementIterator("element");
            classpath = new ArrayList<File>();
            while (it.hasNext()) {
                Element cpElEl = (Element)it.next();
                File cp = new File(cpElEl.attributeValue("path"));
                classpath.add(cp);
            }
        }
        return new JavaShellScriptWriter(javaBin, heapSizeMB, classpath);
    }
}

