/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.hpc.condor;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class SubmitScript {
    private String executable;
    private String arguments;
    private String remoteInitialDir;
    private Universe universe;
    private String logFile;
    private String outFile;
    private String errFile;
    private String environment;
    private String fileName = null;
    private String requirements = null;
    private String imageSize = null;
    private boolean transferExecutable = false;

    public SubmitScript(String exedutable, String arguments, String remoteInitialDir, Universe universe, String logFile, String outFile, String errFile) {
        this.executable = exedutable;
        this.arguments = arguments;
        this.remoteInitialDir = remoteInitialDir;
        this.universe = universe;
        this.logFile = logFile;
        this.outFile = outFile;
        this.errFile = errFile;
    }

    public SubmitScript(String exedutable, String arguments, String remoteInitialDir, Universe universe, String outPrefix, boolean outSubDirs) {
        this.executable = exedutable;
        this.arguments = arguments;
        this.remoteInitialDir = remoteInitialDir;
        this.universe = universe;
        if (outSubDirs) {
            this.logFile = "log" + File.separator + outPrefix + ".log";
            this.outFile = "out" + File.separator + outPrefix + ".out";
            this.errFile = "err" + File.separator + outPrefix + ".err";
        } else {
            this.logFile = outPrefix + ".log";
            this.outFile = outPrefix + ".out";
            this.errFile = outPrefix + ".err";
        }
    }

    public String getScript() {
        Object script = "";
        Preconditions.checkNotNull((Object)((Object)this.universe), (Object)"universe cannot be null");
        script = (String)script + "universe\t=\t" + String.valueOf((Object)this.universe) + "\n";
        Preconditions.checkNotNull((Object)this.executable, (Object)"executable cannot be null");
        Preconditions.checkState((!this.executable.isEmpty() ? 1 : 0) != 0, (Object)"executable cannot be empty");
        script = (String)script + "executable\t=\t" + this.executable + "\n";
        if (this.arguments != null && this.arguments.length() > 0) {
            script = (String)script + "arguments\t=\t" + this.arguments + "\n";
        }
        if (this.environment != null && this.environment.length() > 0) {
            script = (String)script + "environment\t=\t" + this.environment + "\n";
        }
        if (this.requirements != null && this.requirements.length() > 0) {
            script = (String)script + "requirements\t=\t" + this.requirements + "\n";
        }
        if (this.imageSize != null && this.imageSize.length() > 0) {
            script = (String)script + "Image_Size\t=\t" + this.imageSize + "\n";
        }
        script = (String)script + "notification\t=\tNEVER\n";
        script = (String)script + "should_transfer_files\t=\tYES\n";
        script = (String)script + "when_to_transfer_output\t=\tON_EXIT\n";
        script = (String)script + "copy_to_spool\t=\tfalse\n";
        Preconditions.checkNotNull((Object)this.logFile, (Object)"logFile cannot be null");
        Preconditions.checkState((!this.logFile.isEmpty() ? 1 : 0) != 0, (Object)"logFile cannot be empty");
        script = (String)script + "log\t=\t" + this.logFile + "\n";
        Preconditions.checkNotNull((Object)this.errFile, (Object)"errFile cannot be null");
        Preconditions.checkState((!this.errFile.isEmpty() ? 1 : 0) != 0, (Object)"errFile cannot be empty");
        script = (String)script + "error\t=\t" + this.errFile + "\n";
        Preconditions.checkNotNull((Object)this.outFile, (Object)"outFile cannot be null");
        Preconditions.checkState((!this.outFile.isEmpty() ? 1 : 0) != 0, (Object)"outFile cannot be empty");
        script = (String)script + "output\t=\t" + this.outFile + "\n";
        script = (String)script + "transfer_executable\t=\t" + this.transferExecutable + "\n";
        script = (String)script + "transfer_error\t=\ttrue\n";
        script = (String)script + "transfer_output\t=\ttrue\n";
        script = (String)script + "periodic_release\t=\t(NumSystemHolds <= 3)\n";
        script = (String)script + "periodic_remove\t=\t(NumSystemHolds > 3)\n";
        Preconditions.checkNotNull((Object)this.remoteInitialDir, (Object)"remoteInitialDir cannot be null");
        Preconditions.checkState((!this.remoteInitialDir.isEmpty() ? 1 : 0) != 0, (Object)"remoteInitialDir cannot be empty");
        script = (String)script + "remote_initialdir\t=\t" + this.remoteInitialDir + "\n";
        script = (String)script + "queue\n";
        return script;
    }

    public void writeScript(String fileName) throws IOException {
        this.fileName = fileName;
        this.writeScript();
    }

    public void writeScript() throws IOException {
        if (this.fileName == null) {
            throw new NullPointerException("Condor submit script file name was not set before writeScript()!");
        }
        String script = this.getScript();
        FileWriter fw = new FileWriter(this.fileName);
        fw.write(script);
        fw.close();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isTransferExecutable() {
        return this.transferExecutable;
    }

    public void setTransferExecutable(boolean transferExecutable) {
        this.transferExecutable = transferExecutable;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setRequirements(String requirements) {
        this.requirements = requirements;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setImageSize(String imageSize) {
        this.imageSize = imageSize;
    }

    public String getImageSize() {
        return this.imageSize;
    }

    public static enum Universe {
        GRID("grid"),
        VANILLA("vanilla"),
        SCHEDULER("scheduler");

        private String name;

        private Universe(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

