/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.hpc.grid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.metadata.XMLSaveable;

public class GlobusRSL
implements XMLSaveable,
Serializable {
    public static final String JOB_TYPE_NAME = "jobtype";
    public static final String MAX_WALL_TIME_NAME = "maxwalltime";
    public static final String QUEUE_NAME = "queue";
    public static final String SINGLE_JOB_TYPE = "single";
    public static final String XML_METADATA_NAME = "GlobusRSL";
    private ArrayList<String[]> pairs;

    private GlobusRSL(ArrayList<String[]> pairs) {
        this.pairs = pairs;
    }

    public GlobusRSL(String jobType, int maxWallTime) {
        this.pairs = new ArrayList();
        this.addPair(JOB_TYPE_NAME, jobType);
        this.addPair(MAX_WALL_TIME_NAME, "" + maxWallTime);
    }

    public void addPair(String name, String value) {
        String[] pair = new String[]{name, value};
        boolean remove = false;
        int i = 0;
        for (i = 0; i < this.pairs.size(); ++i) {
            String[] check = this.pairs.get(i);
            if (!check[0].equals(pair[0])) continue;
            remove = true;
            break;
        }
        if (remove) {
            this.pairs.remove(i);
        }
        if (value.length() > 0) {
            this.pairs.add(pair);
        }
    }

    public void setQueue(String queueName) {
        this.addPair(QUEUE_NAME, queueName);
    }

    public String getQueue() {
        return this.getValue(QUEUE_NAME);
    }

    public String getJobType() {
        return this.getValue(JOB_TYPE_NAME);
    }

    public int getMaxWallTime() {
        String str = this.getValue(MAX_WALL_TIME_NAME);
        if (str.length() == 0) {
            return -1;
        }
        return Integer.parseInt(str);
    }

    public void setMaxWallTime(int wallTime) {
        this.addPair(MAX_WALL_TIME_NAME, "" + wallTime);
    }

    public String getValue(String name) {
        for (String[] pair : this.pairs) {
            if (!pair[0].equals(name)) continue;
            return pair[1];
        }
        return "";
    }

    public String getRSLString() {
        Object rsl = "";
        for (String[] pair : this.pairs) {
            rsl = (String)rsl + "(" + pair[0] + "=" + pair[1] + ")";
        }
        return rsl;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement(XML_METADATA_NAME);
        for (String[] pair : this.pairs) {
            xml.addAttribute(pair[0], pair[1]);
        }
        return root;
    }

    public static GlobusRSL fromXMLMetadata(Element rslElem) {
        ArrayList<String[]> pairs = new ArrayList<String[]>();
        Iterator attIt = rslElem.attributeIterator();
        while (attIt.hasNext()) {
            Attribute att = (Attribute)attIt.next();
            String[] pair = new String[]{att.getName(), att.getValue()};
            pairs.add(pair);
        }
        return new GlobusRSL(pairs);
    }
}

