/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.logicTree;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.ExceptionUtils;

@JsonAdapter(value=Adapter.class)
public interface BranchWeightProvider {
    public double getWeight(LogicTreeBranch<?> var1);

    public static class TopDownWeights
    implements BranchWeightProvider {
        private LogicTree<?> tree;
        private Map<LogicTreeBranch<?>, Double> weights;

        public TopDownWeights(LogicTree<?> tree) {
            this.tree = tree;
        }

        @Override
        public double getWeight(LogicTreeBranch<?> branch) {
            Preconditions.checkState((boolean)this.tree.contains(branch), (String)"Given branch is not part of the logic tree: %s", branch);
            this.checkCalcWeights();
            return this.weights.get(branch);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkCalcWeights() {
            if (this.weights != null) {
                return;
            }
            TopDownWeights topDownWeights = this;
            synchronized (topDownWeights) {
                if (this.weights != null) {
                    return;
                }
                double[] weightsArray = new double[this.tree.size()];
                for (int i = 0; i < weightsArray.length; ++i) {
                    weightsArray[i] = Double.NaN;
                }
                HashMap nodeBranchesMap = new HashMap();
                HashMap branchIndexMap = new HashMap();
                for (int i = 0; i < weightsArray.length; ++i) {
                    LogicTreeBranch<?> branch = this.tree.getBranch(i);
                    branchIndexMap.put(branch, i);
                    for (LogicTreeNode node : branch) {
                        ArrayList nodeBranches = (ArrayList)nodeBranchesMap.get(node);
                        if (nodeBranches == null) {
                            nodeBranches = new ArrayList();
                            nodeBranchesMap.put(node, nodeBranches);
                        }
                        nodeBranches.add(branch);
                    }
                }
                this.weightProcessRecursive(weightsArray, nodeBranchesMap, branchIndexMap, 0, null, 1.0);
                HashMap weights = new HashMap();
                for (int i = 0; i < weightsArray.length; ++i) {
                    LogicTreeBranch<?> branch = this.tree.getBranch(i);
                    Preconditions.checkState((boolean)Double.isFinite(weightsArray[i]), (String)"Bad weight=%s for branch %s: %s", (Object)weightsArray[i], (Object)i, branch);
                    weights.put(branch, weightsArray[i]);
                }
                this.weights = weights;
            }
        }

        private void weightProcessRecursive(double[] weightsArray, Map<LogicTreeNode, List<LogicTreeBranch<?>>> nodeBranchesMap, Map<LogicTreeBranch<?>, Integer> branchIndexMap, int startingLevelIndex, LogicTreeBranch<LogicTreeNode> upstreamBranch, double upstreamWeight) {
            double nodeWeight;
            Preconditions.checkState((upstreamWeight > 0.0 ? 1 : 0) != 0, (String)"Bad upstreamWeight=%s for upstreamBranch=%s", (Object)upstreamWeight, upstreamBranch);
            LogicTreeLevel level = (LogicTreeLevel)this.tree.getLevels().get(startingLevelIndex);
            boolean lastLevel = startingLevelIndex == this.tree.getLevels().size() - 1;
            double sumWeight = 0.0;
            ArrayList<LogicTreeNode> nodes = new ArrayList<LogicTreeNode>();
            ArrayList nodeBranches = new ArrayList();
            ArrayList<Double> nodeWeights = new ArrayList<Double>();
            for (LogicTreeNode node : level.getNodes()) {
                List<LogicTreeBranch<?>> allNodeBranches = nodeBranchesMap.get(node);
                if (allNodeBranches == null) continue;
                nodeWeight = node.getNodeWeight(upstreamBranch);
                ArrayList myNodeBranches = new ArrayList();
                for (LogicTreeBranch<?> branch : allNodeBranches) {
                    boolean match = true;
                    if (upstreamBranch != null) {
                        for (LogicTreeNode upstreamNode : upstreamBranch) {
                            if (branch.hasValue(upstreamNode)) continue;
                            match = false;
                            break;
                        }
                    }
                    if (!match) continue;
                    myNodeBranches.add(branch);
                }
                if (myNodeBranches.isEmpty()) continue;
                nodes.add(node);
                nodeBranches.add(myNodeBranches);
                nodeWeights.add(nodeWeight);
                sumWeight += nodeWeight;
            }
            Preconditions.checkState((sumWeight > 0.0 ? 1 : 0) != 0, (String)"sumWeight=%s for level %s with upstream %s", (Object)sumWeight, (Object)level.getName(), upstreamBranch);
            ArrayList<LogicTreeLevel<LogicTreeLevel>> downstreamLevels = null;
            if (!lastLevel) {
                downstreamLevels = new ArrayList<LogicTreeLevel<LogicTreeLevel>>();
                if (upstreamBranch != null) {
                    for (LogicTreeLevel upLevel : upstreamBranch.getLevels()) {
                        downstreamLevels.add(upLevel);
                    }
                }
                downstreamLevels.add(level);
            }
            for (int n = 0; n < nodes.size(); ++n) {
                LogicTreeNode node = (LogicTreeNode)nodes.get(n);
                nodeWeight = (Double)nodeWeights.get(n);
                if (sumWeight != 1.0) {
                    nodeWeight /= sumWeight;
                }
                List branches = (List)nodeBranches.get(n);
                Preconditions.checkState((nodeWeight > 0.0 ? 1 : 0) != 0, (String)"Bad nodeWeight=%s for node %s and upstreamBranch=%s", (Object)nodeWeight, (Object)node.getName(), upstreamBranch);
                if (lastLevel) {
                    for (LogicTreeBranch<Object> branch : branches) {
                        int index = branchIndexMap.get(branch);
                        weightsArray[index] = upstreamWeight * nodeWeight;
                    }
                    continue;
                }
                LogicTreeBranch<LogicTreeNode> downstreamBranch = new LogicTreeBranch<LogicTreeNode>(downstreamLevels);
                if (upstreamBranch != null) {
                    for (LogicTreeNode upstreamNode : upstreamBranch) {
                        downstreamBranch.setValue(upstreamNode);
                    }
                }
                downstreamBranch.setValue(node);
                double downstreamWeight = upstreamWeight * nodeWeight;
                this.weightProcessRecursive(weightsArray, nodeBranchesMap, branchIndexMap, startingLevelIndex + 1, downstreamBranch, downstreamWeight);
            }
        }
    }

    public static class NodeWeightOverrides
    implements BranchWeightProvider {
        private Map<LogicTreeNode, Double> nodeWeights;

        public NodeWeightOverrides(LogicTreeNode[] nodes, double weight) {
            this.nodeWeights = new HashMap<LogicTreeNode, Double>();
            for (LogicTreeNode node : nodes) {
                this.nodeWeights.put(node, weight);
            }
        }

        public NodeWeightOverrides(Map<LogicTreeNode, Double> nodeWeights) {
            this.nodeWeights = nodeWeights;
        }

        @Override
        public double getWeight(LogicTreeBranch<?> branch) {
            double wt = 1.0;
            for (LogicTreeNode value : branch) {
                if (value == null) continue;
                Double hardcoded = this.nodeWeights.get(value);
                if (hardcoded != null) {
                    wt *= hardcoded.doubleValue();
                    continue;
                }
                wt *= value.getNodeWeight(branch);
            }
            return wt;
        }
    }

    public static class Adapter
    extends TypeAdapter<BranchWeightProvider> {
        private Gson gson = new Gson();

        public void write(JsonWriter out, BranchWeightProvider value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value(value.getClass().getName());
            out.name("data");
            this.gson.toJson((Object)value, value.getClass(), out);
            out.endObject();
        }

        public BranchWeightProvider read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                return null;
            }
            in.beginObject();
            Class<?> type = null;
            BranchWeightProvider ret = null;
            block10: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "type": {
                        String typeStr = in.nextString();
                        try {
                            type = Class.forName(typeStr);
                            continue block10;
                        }
                        catch (Exception e) {
                            throw ExceptionUtils.asRuntimeException(e);
                        }
                    }
                    case "data": {
                        Preconditions.checkNotNull(type, (Object)"type must be specified before adapter data");
                        ret = (BranchWeightProvider)this.gson.fromJson(in, type);
                        continue block10;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            Preconditions.checkNotNull(ret, (Object)"Missing 'data' and/or 'type' field, can't deserialize");
            return ret;
        }
    }

    public static class HardcodedWeights
    implements BranchWeightProvider {
        private Map<LogicTreeBranch<?>, Double> weights;

        public HardcodedWeights(Map<LogicTreeBranch<?>, Double> weights) {
            this.weights = weights;
        }

        @Override
        public double getWeight(LogicTreeBranch<?> branch) {
            Double weight = this.weights.get(branch);
            Preconditions.checkState((weight != null ? 1 : 0) != 0, (String)"No hardcoded weight exists for branch: %s", branch);
            return weight;
        }
    }

    public static class ConstantWeights
    implements BranchWeightProvider {
        private double weightEach;

        public ConstantWeights() {
            this(1.0);
        }

        public ConstantWeights(double weightEach) {
            this.weightEach = weightEach;
        }

        @Override
        public double getWeight(LogicTreeBranch<?> branch) {
            return this.weightEach;
        }
    }

    public static class CurrentWeights
    implements BranchWeightProvider {
        @Override
        public double getWeight(LogicTreeBranch<?> branch) {
            return branch.getBranchWeight();
        }
    }

    public static class OriginalWeights
    implements BranchWeightProvider {
        @Override
        public double getWeight(LogicTreeBranch<?> branch) {
            return branch.getOrigBranchWeight();
        }
    }
}

