/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.gui.DisclaimerDialog;
import org.opensha.commons.mapping.gmt.gui.GMT_MapGuiBean;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.impl.StringParameterEditor;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.gui.util.IconFetcher;

public class GMT_MapGeneratorApplet
extends JPanel {
    public static final String APP_NAME = "GMT Map Generator Application";
    public static final String APP_SHORT_NAME = "GMTMap";
    private static ApplicationVersion version;
    private static final String C = "GMT_MapGeneratorApplet";
    private static final boolean D = false;
    private JPanel mainPanel = new JPanel();
    private JSplitPane mainSplitPane = new JSplitPane();
    private JPanel buttonPanel = new JPanel();
    Insets defaultInsets = new Insets(4, 4, 4, 4);
    String mapFileName = null;
    protected static final int W = 600;
    protected static final int H = 750;
    private JButton addButton = new JButton();
    private GMT_MapGuiBean gmtGuiBean = null;
    private static final String URL_NAME = "Enter URL";
    private StringParameter xyzFileName = new StringParameter("Enter URL", "https://data.opensha.org/data/step/backGround.txt");
    private StringParameterEditor xyzFileEditor;
    private JPanel parameterPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private BorderLayout borderLayout1 = new BorderLayout();

    public static ApplicationVersion getAppVersion() {
        if (version == null) {
            try {
                version = ApplicationVersion.loadBuildVersion();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    public String getParameter(String key, String def) {
        return System.getProperty(key, def);
    }

    public void init() {
        try {
            this.jbInit();
            this.xyzFileEditor = new StringParameterEditor((Parameter)this.xyzFileName);
            this.parameterPanel.add((Component)this.xyzFileEditor, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, this.defaultInsets, 0, 0));
            this.gmtGuiBean = new GMT_MapGuiBean();
            this.parameterPanel.add((Component)this.gmtGuiBean, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
            this.parameterPanel.validate();
            this.parameterPanel.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(492, 686));
        this.setLayout(this.borderLayout1);
        this.mainPanel.setLayout(this.gridBagLayout3);
        this.mainSplitPane.setOrientation(0);
        this.mainSplitPane.setLastDividerLocation(670);
        this.buttonPanel.setLayout(this.gridBagLayout1);
        this.addButton.setText("Make Map");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GMT_MapGeneratorApplet.this.addButton_actionPerformed(e);
            }
        });
        this.parameterPanel.setLayout(this.gridBagLayout2);
        this.add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.mainSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 6, 6), 0, 595));
        this.mainSplitPane.add((Component)this.buttonPanel, "right");
        this.buttonPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(15, 47, 14, 300), 27, 9));
        this.mainSplitPane.add((Component)this.parameterPanel, "left");
        this.mainSplitPane.setDividerLocation(630);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "MAPS using the GMT";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    public static void main(String[] args) {
        new DisclaimerDialog(APP_NAME, APP_SHORT_NAME, GMT_MapGeneratorApplet.getAppVersion());
        GMT_MapGeneratorApplet.launch();
    }

    public static GMT_MapGeneratorApplet launch() {
        GMT_MapGeneratorApplet applet = new GMT_MapGeneratorApplet();
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setTitle("GMT Map Generator Application (" + String.valueOf(GMT_MapGeneratorApplet.getAppVersion()) + ")");
        frame.getContentPane().add((Component)applet, "Center");
        applet.init();
        frame.setIconImages(IconFetcher.fetchIcons(APP_SHORT_NAME));
        applet.start();
        frame.setSize(600, 750);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
        return applet;
    }

    void addButton_actionPerformed(ActionEvent e) {
        this.addButton();
    }

    void addButton() {
        String fileName = (String)this.xyzFileName.getValue();
        ArbDiscrGeoDataSet xyzData = new ArbDiscrGeoDataSet(true);
        if (fileName != null) {
            try {
                URL fileURL = new URL((String)this.xyzFileName.getValue());
                ArrayList<String> fileLines = FileUtils.loadFile(fileURL);
                ListIterator<String> it = fileLines.listIterator();
                while (it.hasNext()) {
                    StringTokenizer st = new StringTokenizer(it.next());
                    double lat = Double.valueOf(st.nextToken().trim());
                    double lon = Double.valueOf(st.nextToken().trim());
                    double z = Double.valueOf(st.nextToken().trim());
                    xyzData.set(new Location(lat, lon), z);
                }
            }
            catch (Exception ee) {
                JOptionPane.showMessageDialog(this, new String("Please enter URL"), "Error", 0);
                ee.printStackTrace();
            }
        }
        String metadata = "You can download the jpg or postscript files for:\n\t" + fileName + "\n\nFrom (respectively):";
        this.gmtGuiBean.makeMap(xyzData, metadata);
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

