/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.DiscreteParameterConstraint;
import org.opensha.commons.param.constraint.ParameterConstraint;

public class ParameterList
implements Serializable,
Iterable<Parameter<?>> {
    private static final long serialVersionUID = -3799009507357699361L;
    protected static final String C = "ParameterList";
    protected static final boolean D = false;
    protected ArrayList<Parameter<?>> params = new ArrayList();
    protected Hashtable<String, String> constraintNameMap = new Hashtable();
    private transient ArrayList<ChangeListener> changeListeners;

    public void addParameterList(ParameterList list2) throws ParameterException {
        ListIterator<Parameter<?>> it = list2.getParametersIterator();
        while (it.hasNext()) {
            Parameter<?> param = it.next();
            if (this.containsParameter(param)) continue;
            this.addParameter(param);
        }
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public void addParameter(Parameter param) throws ParameterException {
        this.addParameter(-1, param);
    }

    public void addParameter(int index, Parameter param) throws ParameterException {
        String S = "ParameterList: addParameter(): ";
        String name = param.getName();
        String constraintName = param.getConstraintName();
        this.fireChangeEvent(new ChangeEvent(this));
        if (this.getIndexOf(name) == -1) {
            if (index >= 0) {
                this.params.add(index, param);
            } else {
                this.params.add(param);
            }
        } else {
            throw new ParameterException(S + "A Parameter already exists named " + name);
        }
        if (constraintName == null || constraintName.equals("") || constraintName.equals(name)) {
            return;
        }
        if (this.constraintNameMap.containsKey(constraintName)) {
            this.params.remove(name);
            throw new ParameterException(S + "A Parameter already exists with this constraint named " + constraintName);
        }
        this.constraintNameMap.put(constraintName, name);
    }

    public String getParameterName(String name) {
        if (this.constraintNameMap.containsKey(name)) {
            return this.constraintNameMap.get(name);
        }
        return name;
    }

    public Parameter getParameter(String name) throws ParameterException {
        int index = this.getIndexOf(name = this.getParameterName(name));
        if (index != -1) {
            Parameter<?> param = this.params.get(index);
            return param;
        }
        String S = "ParameterList: getParameter(): ";
        throw new ParameterException(S + "No parameter exists named " + name);
    }

    public <T> Parameter<T> getParameter(Class<T> type, String name) {
        return this.getParameter(name);
    }

    public Parameter getParameter(int index) throws ParameterException {
        if (index >= 0 && index < this.params.size()) {
            Parameter<?> param = this.params.get(index);
            return param;
        }
        String S = "ParameterList: getParameter(): ";
        throw new ParameterException(S + "No parameter exists at index " + index);
    }

    public <T> Parameter<T> getParameter(Class<T> type, int index) {
        return this.getParameter(index);
    }

    public Object getValue(String name) throws ParameterException {
        int index = this.getIndexOf(name = this.getParameterName(name));
        if (index != -1) {
            Parameter<?> param = this.params.get(index);
            Object obj = param.getValue();
            return obj;
        }
        String S = "ParameterList: getValue(): ";
        throw new ParameterException(S + "No parameter exists named " + name);
    }

    public Parameter getByIndex(int index) {
        return this.params.get(index);
    }

    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public <T> Parameter<T> getByIndex(Class<T> type, int index) {
        return this.getByIndex(index);
    }

    public void setValue(String name, Object value) throws ParameterException, ConstraintException {
        String S = "ParameterList: setValue(): ";
        int index = this.getIndexOf(name = this.getParameterName(name));
        if (index == -1) {
            throw new ParameterException(S + "No parameter exists named " + name);
        }
        Parameter<?> param = this.params.get(index);
        param.setValue(value);
    }

    public String getType(String name) throws ParameterException {
        int index = this.getIndexOf(name = this.getParameterName(name));
        if (index != -1) {
            Parameter<?> param = this.params.get(index);
            String str = param.getType();
            return str;
        }
        String S = "ParameterList: getType(): ";
        throw new ParameterException(S + "No parameter exists named " + name);
    }

    public boolean containsParameter(Parameter param) {
        String name = param.getName();
        int index = this.getIndexOf(name);
        return index != -1;
    }

    public boolean containsParameter(String paramName) {
        int index = this.getIndexOf(paramName);
        return index != -1;
    }

    public void removeParameter(Parameter param) throws ParameterException {
        String name = param.getName();
        this.removeParameter(name);
    }

    public void removeParameter(String name) throws ParameterException {
        int index = this.getIndexOf(name);
        if (index == -1) {
            String S = "ParameterList: removeParameter(): ";
            throw new ParameterException(S + "No Parameter exist named " + name + ", unable to remove");
        }
        this.params.remove(index);
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public void updateParameter(Parameter param) throws ParameterException {
        String name = param.getName();
        this.removeParameter(name);
        this.addParameter(param);
    }

    public ListIterator<Parameter<?>> getParametersIterator() {
        ArrayList v = new ArrayList();
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            Parameter<?> obj = this.params.get(i);
            v.add(obj);
        }
        return v.listIterator();
    }

    public void replaceParameter(String parameterName, Parameter param) {
        int index = this.getIndexOf(parameterName = this.getParameterName(parameterName));
        if (index != -1) {
            this.removeParameter(parameterName);
            this.addParameter(param);
        }
    }

    public int compareTo(Object obj) {
        Parameter<?> param1;
        Parameter param2;
        int result = 0;
        if (!(obj instanceof ParameterList)) {
            throw new ClassCastException("ParameterListObject not a ParameterList, unable to compare");
        }
        ParameterList paramList = (ParameterList)obj;
        ListIterator<Parameter<?>> it = paramList.getParametersIterator();
        if (this.size() != paramList.size()) {
            return -1;
        }
        while (it.hasNext() && (result = (param2 = this.getParameter((param1 = it.next()).getName())).compareTo(param1)) == 0) {
        }
        return result;
    }

    public ListIterator<String> getParameterNamesIterator() {
        ArrayList<String> v = new ArrayList<String>();
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            Parameter<?> obj = this.params.get(i);
            v.add(obj.getName());
        }
        return v.listIterator();
    }

    public void clear() {
        this.params.clear();
    }

    public int size() {
        return this.params.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParameterList)) {
            return false;
        }
        ParameterList list = (ParameterList)obj;
        if (this.size() != list.size()) {
            return false;
        }
        for (Parameter<?> p : list) {
            if (!this.containsParameter(p.getName())) {
                return false;
            }
            if (this.getParameter(p.getName()).equals(p)) continue;
            return false;
        }
        for (Parameter<?> p : this) {
            if (!list.containsParameter(p.getName())) {
                return false;
            }
            if (list.getParameter(p.getName()).equals(p)) continue;
            return false;
        }
        return true;
    }

    public boolean equalNames(ParameterList list) {
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator<Parameter<?>> it = this.getParametersIterator();
        while (it.hasNext()) {
            Parameter<?> param1 = it.next();
            if (list.containsParameter(param1.getName())) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        ParameterList list = new ParameterList();
        if (this.size() < 1) {
            return list;
        }
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            Parameter<?> param = this.params.get(i);
            list.addParameter((Parameter)param.clone());
        }
        return list;
    }

    public String toString() {
        String S = "ParameterList: toString():";
        StringBuffer b = new StringBuffer();
        boolean first = true;
        ArrayList<String> v = new ArrayList<String>();
        int vectorSize = this.params.size();
        for (int i = 0; i < vectorSize; ++i) {
            Parameter<?> param = this.params.get(i);
            v.add(param.getName());
        }
        for (String key : v) {
            int size;
            int index = this.getIndexOf(key);
            Parameter<?> param = this.params.get(index);
            ParameterConstraint constraint = param.getConstraint();
            boolean ok = true;
            if (constraint instanceof DiscreteParameterConstraint && (size = ((DiscreteParameterConstraint)constraint).size()) < 2) {
                ok = false;
            }
            if (!ok) continue;
            String val = "N/A";
            Object obj = param.getValue();
            if (obj != null) {
                val = obj.toString();
            }
            if (first) {
                first = false;
                b.append(key + " = " + val);
                continue;
            }
            b.append(", " + key + " = " + val);
        }
        return b.toString();
    }

    public String getParameterListMetadataString() {
        return this.getParameterListMetadataString("; ");
    }

    public String getParameterListMetadataString(String delimiter) {
        int size = this.params.size();
        StringBuffer metaData = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < size; ++i) {
            Parameter<?> tempParam = this.params.get(i);
            if (first) {
                metaData.append(tempParam.getMetadataString());
                first = false;
                continue;
            }
            metaData.append(delimiter + tempParam.getMetadataString());
        }
        return metaData.toString();
    }

    private int getIndexOf(String key) {
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            Parameter<?> param = this.params.get(i);
            if (!key.equalsIgnoreCase(param.getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<Parameter<?>> iterator() {
        return this.params.iterator();
    }

    public static boolean setParamsInListFromXML(ParameterList paramList, Element paramListEl) {
        boolean failure = false;
        for (Parameter<?> param : paramList) {
            Iterator it = paramListEl.elementIterator();
            boolean matched = false;
            while (it.hasNext()) {
                Element el = (Element)it.next();
                if (!param.getName().equals(el.attribute("name").getValue())) continue;
                matched = true;
                if (param.setValueFromXMLMetadata(el)) continue;
                System.err.println("Parameter " + param.getName() + " could not be set from XML!");
                System.err.println("It is possible that the parameter type doesn't yet support loading from XML");
                failure = true;
            }
            if (matched) continue;
            System.err.println("Parameter '" + param.getName() + "' from XML can not be set because it can't be found in the given ParameterList!");
            failure = true;
        }
        return !failure;
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null && this.changeListeners.contains(listener)) {
            this.changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(ChangeEvent event) {
        ChangeListener[] changeListenerArray = this;
        synchronized (this) {
            if (this.changeListeners == null) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            ChangeListener[] listeners = new ChangeListener[this.changeListeners.size()];
            this.changeListeners.toArray(listeners);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (ChangeListener listener : listeners) {
                listener.stateChanged(event);
            }
            return;
        }
    }

    public static ParameterList intersection(ParameterList ... lists) throws ParameterException {
        if (lists == null || lists.length == 0) {
            return new ParameterList();
        }
        HashSet<String> commonNames = new HashSet<String>();
        ListIterator<String> it = lists[0].getParameterNamesIterator();
        while (it.hasNext()) {
            commonNames.add(it.next());
        }
        for (int i = 1; i < lists.length; ++i) {
            HashSet<String> currentNames = new HashSet<String>();
            it = lists[i].getParameterNamesIterator();
            while (it.hasNext()) {
                currentNames.add(it.next());
            }
            commonNames.retainAll(currentNames);
        }
        ParameterList result = new ParameterList();
        for (String name : commonNames) {
            Parameter param = lists[0].getParameter(name);
            result.addParameter(param);
        }
        return result;
    }

    public static ParameterList union(ParameterList ... lists) throws ParameterException {
        ParameterList result = new ParameterList();
        if (lists == null || lists.length == 0) {
            return result;
        }
        for (ParameterList list : lists) {
            for (Parameter<?> param : list) {
                if (result.containsParameter(param.getName())) continue;
                result.addParameter(param);
            }
        }
        return result;
    }

    public ParameterList getVisibleParams() {
        ParameterList visible = new ParameterList();
        for (Parameter<?> param : this) {
            if (!param.isEditorBuilt() || !param.getEditor().isVisible()) continue;
            visible.addParameter(param);
        }
        return visible;
    }
}

