/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.constraint.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.param.constraint.AbstractParameterConstraint;
import org.opensha.commons.param.constraint.DiscreteParameterConstraint;

public class DoubleDiscreteConstraint
extends AbstractParameterConstraint<Double>
implements DiscreteParameterConstraint<Double> {
    private static final long serialVersionUID = 1L;
    protected static final String C = "DoubleDiscreteConstraint";
    protected static final boolean D = false;
    private List<Double> doubles = new ArrayList<Double>();

    public DoubleDiscreteConstraint() {
    }

    public DoubleDiscreteConstraint(List<Double> doubles) throws ConstraintException {
        if (doubles.size() <= 0) {
            String S = "DoubleDiscreteConstraint: Constructor(ArrayList doubles): ";
            throw new ConstraintException(S + "Input vector of constraint values cannot be empty");
        }
        this.doubles = doubles;
    }

    public void setDoubles(List<Double> doubles) throws EditableException {
        if (!this.editable) {
            throw new EditableException("DoubleDiscreteConstraint: setStrings(): This constraint is currently not editable.");
        }
        this.doubles = doubles;
    }

    @Override
    public List<Double> getAllowedValues() {
        return this.getAllowedDoubles();
    }

    public List<Double> getAllowedDoubles() {
        return Lists.newArrayList(this.doubles);
    }

    @Override
    public boolean isAllowed(Double d) {
        if (this.nullAllowed && d == null) {
            return true;
        }
        return this.containsDouble(d);
    }

    @Override
    public boolean isAllowed(double d) {
        return this.isAllowed((Double)d);
    }

    @Override
    public ListIterator<Double> listIterator() {
        return this.doubles.listIterator();
    }

    public void addDouble(double d) throws EditableException {
        this.addDouble((Double)d);
    }

    public void addDouble(Double d) throws EditableException {
        String S = "DoubleDiscreteConstraint: addDouble( Double ): ";
        this.checkEditable(S);
        if (!this.containsDouble(d)) {
            this.doubles.add(d);
        }
    }

    public void removeDouble(Double d) throws EditableException {
        String S = "DoubleDiscreteConstraint: removeDouble( Double ): ";
        this.checkEditable(S);
        if (this.containsDouble(d)) {
            this.doubles.remove(d);
        }
    }

    public void removeDouble(double d) throws EditableException {
        this.removeDouble((Double)d);
    }

    public boolean containsDouble(Double d) {
        return this.doubles.contains(d);
    }

    public boolean containsDouble(double d) {
        return this.containsDouble((Double)d);
    }

    @Override
    public int size() {
        return this.doubles.size();
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer b = new StringBuffer();
        b.append(this.getClass().getName());
        if (this.name != null) {
            b.append(TAB + "Name = " + this.name + "\n");
        }
        b.append(TAB.concat("Allowed values = "));
        ListIterator<Double> it = this.doubles.listIterator();
        boolean first = true;
        while (it.hasNext()) {
            if (!first) {
                b.append(TAB + ", " + String.valueOf(it.next()));
                continue;
            }
            b.append(TAB + String.valueOf(it.next()));
            first = false;
        }
        b.append(TAB + "Null Allowed = " + this.nullAllowed + "\n");
        return b.toString();
    }

    @Override
    public Object clone() {
        DoubleDiscreteConstraint c1 = new DoubleDiscreteConstraint();
        c1.setName(this.name);
        List<Double> v = this.getAllowedDoubles();
        ListIterator<Double> it = v.listIterator();
        while (it.hasNext()) {
            Double val = it.next();
            Double val2 = (double)val;
            c1.addDouble(val2);
        }
        c1.setNullAllowed(this.nullAllowed);
        c1.editable = true;
        return c1;
    }
}

