/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.constraint.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.opensha.commons.param.constraint.AbstractParameterConstraint;

public class IntegerDiscreteConstraint
extends AbstractParameterConstraint<Integer> {
    private static final long serialVersionUID = 1L;
    private static final String S = "IntegerDiscreteConstraint";
    private ArrayList<Integer> allowed;

    public IntegerDiscreteConstraint(ArrayList<Integer> allowed) {
        this.setAllowed(allowed);
    }

    public void setAllowed(ArrayList<Integer> allowed) {
        this.checkEditable(S);
        Preconditions.checkNotNull(allowed, (Object)"Allowed cannot be null!");
        this.allowed = allowed;
    }

    @Override
    public boolean isAllowed(Integer obj) {
        if (obj == null) {
            return this.isNullAllowed();
        }
        return this.allowed.contains(obj);
    }

    @Override
    public Object clone() {
        IntegerDiscreteConstraint iconst = new IntegerDiscreteConstraint(this.allowed);
        iconst.setNullAllowed(this.isNullAllowed());
        if (!this.isEditable()) {
            iconst.setNonEditable();
        }
        return iconst;
    }

    public ArrayList<Integer> getAllowed() {
        return this.allowed;
    }

    public void addAllowed(Integer val) {
        this.allowed.add(val);
    }

    public int size() {
        return this.allowed.size();
    }
}

