/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.constraint.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.constraint.AbstractParameterConstraint;
import org.opensha.commons.param.constraint.DiscreteParameterConstraint;

public class LocationConstraint
extends AbstractParameterConstraint<Location>
implements DiscreteParameterConstraint<Location> {
    private static final long serialVersionUID = 1L;
    protected static final String C = "LocationConstraint";
    protected static final boolean D = false;
    private List<Location> locations;

    public LocationConstraint() {
        this.locations = new ArrayList<Location>();
    }

    public LocationConstraint(List<Location> locations) throws ConstraintException {
        if (locations.size() <= 0) {
            String S = "LocationConstraint: Constructor(ArrayList locations): ";
            throw new ConstraintException(S + "Input vector of constraint values cannot be empty");
        }
        this.locations = locations;
    }

    public void setLocations(List<Location> locations) throws ConstraintException, EditableException {
        String S = "LocationConstraint: setLocations(): ";
        this.checkEditable(S);
        if (locations == null || locations.size() <= 0) {
            throw new ConstraintException(S + "Input vector of constraint values cannot be null or empty");
        }
        this.locations = locations;
    }

    public List<Location> getAllowedLocations() {
        return Collections.unmodifiableList(this.locations);
    }

    @Override
    public List<Location> getAllowedValues() {
        return this.getAllowedLocations();
    }

    @Override
    public boolean isAllowed(Location loc) {
        if (this.nullAllowed && loc == null) {
            return true;
        }
        if (!(loc instanceof Location)) {
            return false;
        }
        return this.containsLocation(loc);
    }

    @Override
    public ListIterator listIterator() {
        return this.locations.listIterator();
    }

    public void addLocation(Location loc) throws EditableException {
        this.checkEditable("LocationConstraint: addLocation(): ");
        if (!this.containsLocation(loc)) {
            this.locations.add(loc);
        }
    }

    public void removeLocation(Location loc) throws EditableException {
        this.checkEditable("LocationConstraint: removeLocation(): ");
        if (this.containsLocation(loc)) {
            this.locations.remove(loc);
        }
    }

    public boolean containsLocation(Location loc) {
        return this.locations.contains(loc);
    }

    @Override
    public int size() {
        return this.locations.size();
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer b = new StringBuffer();
        b.append(C);
        if (this.name != null) {
            b.append(TAB + "Name = " + this.name + "\n");
        }
        b.append(TAB + "Allowed values = ");
        boolean first = true;
        ListIterator<Location> it = this.locations.listIterator();
        while (it.hasNext()) {
            if (!first) {
                b.append(TAB + ", " + ((Object)it.next()).toString());
                continue;
            }
            b.append(TAB + ((Object)it.next()).toString());
            first = false;
        }
        b.append(TAB + "Null Allowed = " + this.nullAllowed + "\n");
        return b.toString();
    }

    @Override
    public Object clone() {
        LocationConstraint c1 = new LocationConstraint();
        c1.name = this.name;
        List<Location> v = this.getAllowedLocations();
        ListIterator<Location> it = v.listIterator();
        while (it.hasNext()) {
            Location loc = it.next();
            c1.addLocation(loc);
        }
        c1.setNullAllowed(this.nullAllowed);
        c1.editable = true;
        return c1;
    }
}

