/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.demo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensha.commons.data.ValueWeight;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.IntegerConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.ArbitrarilyDiscretizedFuncParameter;
import org.opensha.commons.param.impl.DoubleDiscreteParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.DoubleValueWeightParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.LocationParameter;
import org.opensha.commons.param.impl.ParameterListParameter;
import org.opensha.commons.param.impl.RegionParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.param.impl.WarningDoubleParameter;
import org.opensha.commons.param.impl.WarningIntegerParameter;

public class ParameterApplet
extends JFrame
implements ParameterChangeListener,
ParameterChangeFailListener,
ParameterChangeWarningListener {
    protected static final String C = "ParameterApplet";
    protected static final boolean D = true;
    static final int NUM = 6;
    static int paramCount = 0;
    boolean isStandalone = true;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel statusLabel = new JLabel();
    JLabel mainTitleLabel = new JLabel();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();

    public String getParameter(String key, String def) {
        return System.getProperty(key, def);
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setBackground(Color.white);
        this.setSize(new Dimension(400, 300));
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setMinimumSize(new Dimension(100, 300));
        this.jPanel1.setPreferredSize(new Dimension(100, 300));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.mainTitleLabel.setBackground(Color.white);
        this.mainTitleLabel.setFont(new Font("Dialog", 1, 14));
        this.mainTitleLabel.setBorder(BorderFactory.createEtchedBorder());
        this.mainTitleLabel.setHorizontalAlignment(0);
        this.mainTitleLabel.setText("Parameter Editor Applet");
        this.jPanel2.setBackground(Color.white);
        this.jPanel2.setFont(new Font("Dialog", 0, 10));
        this.jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPanel2.setLayout(this.gridBagLayout2);
        this.statusLabel.setFont(new Font("Dialog", 1, 10));
        this.statusLabel.setForeground(Color.black);
        this.statusLabel.setText("Status");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.mainTitleLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        ParameterList list = this.makeParameterList(5);
        ParameterListEditor editor = new ParameterListEditor(list);
        this.jPanel1.add((Component)editor, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanel1.add((Component)this.jPanel2, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.statusLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
    }

    private ParameterList makeParameterList(int number) {
        ArrayList<String> val = new ArrayList<String>();
        val.add("Steven");
        val.add("William");
        val.add("Michael");
        StringConstraint constraint = new StringConstraint(val);
        ParameterList list = new ParameterList();
        list.addParameter(this.makeConstrainedStringParameter(constraint));
        list.addParameter(this.makeStringParameter());
        list.addParameter(this.makeDoubleParameter());
        list.addParameter(this.makeIntegerParameter());
        list.addParameter(this.makeConstrainedIntegerParameter());
        list.addParameter(this.makeConstrainedDoubleDiscreteParameter());
        list.addParameter(this.makeWarningDoubleParameter());
        list.addParameter(this.makeWarningIntegerParameter());
        for (int i = 3; i < number; ++i) {
            list.addParameter(this.makeStringParameter());
        }
        list.addParameter(this.makeParameterListParameter());
        list.addParameter(this.makeDoubleValueWeightParameter());
        list.addParameter(this.makeLocationParameter());
        list.addParameter(this.makeRegionParameter());
        list.addParameter(this.makeArbitrarilyDiscretizedFuncParameter());
        return list;
    }

    private Parameter makeLocationParameter() {
        String name = "Location Parameter";
        ++paramCount;
        LocationParameter param = new LocationParameter("Location Param", new Location(34.0, -120.0, 0.0));
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private Parameter makeRegionParameter() {
        String name = "Region Parameter";
        ++paramCount;
        AbstractParameter param = null;
        try {
            param = new RegionParameter("Region Param", "Kevin's/Sec", 34.0, 36.0, -120.0, -118.0);
        }
        catch (ConstraintException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private Parameter makeDoubleValueWeightParameter() {
        String name = "Double Value Weight Parameter";
        ++paramCount;
        DoubleValueWeightParameter param = new DoubleValueWeightParameter(name, 0.0, 1.0, 0.0, 1000.0, "mm/yr", new ValueWeight(0.5, 99.9));
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private Parameter makeParameterListParameter() {
        DoubleParameter param1 = new DoubleParameter("param1", 0.01);
        DoubleParameter param2 = new DoubleParameter("param2", 0.02);
        ParameterList paramList = new ParameterList();
        paramList.addParameter(param1);
        paramList.addParameter(param2);
        ParameterListParameter param = new ParameterListParameter("Parameter List", paramList);
        return param;
    }

    private Parameter makeArbitrarilyDiscretizedFuncParameter() {
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        func.setName("test func");
        func.set(20.0, 5.0);
        func.set(40.0, 6.0);
        func.set(60.0, 7.0);
        return new ArbitrarilyDiscretizedFuncParameter("ArbitrarilyDiscretizedFuncParameter", func);
    }

    private Parameter makeConstrainedDoubleDiscreteParameter() {
        String name = "Constrained Double Discrete Parameter";
        String value = "12.1";
        ++paramCount;
        ArrayList<Double> val = new ArrayList<Double>();
        val.add(11.1);
        val.add(12.1);
        val.add(13.1);
        DoubleDiscreteConstraint constraint = new DoubleDiscreteConstraint(val);
        DoubleDiscreteParameter param = new DoubleDiscreteParameter(name, constraint, "sec.", (Double)12.1);
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private Parameter makeIntegerParameter() {
        String name = "Integer Parameter";
        String value = "1" + paramCount;
        ++paramCount;
        IntegerParameter param = new IntegerParameter(name, Integer.valueOf(value));
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private Parameter makeConstrainedIntegerParameter() {
        String name = "Constrained Integer Parameter";
        String value = "1" + paramCount;
        ++paramCount;
        IntegerConstraint constraint = new IntegerConstraint(-180, 180);
        IntegerParameter param = new IntegerParameter(name, (ParameterConstraint<Integer>)constraint, "degrees", Integer.valueOf(value));
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private Parameter makeWarningIntegerParameter() {
        String name = "Warning Integer Parameter";
        String value = "1" + paramCount;
        ++paramCount;
        IntegerConstraint constraint = new IntegerConstraint(-200, 200);
        IntegerConstraint warnConstraint = new IntegerConstraint(-100, 100);
        WarningIntegerParameter param = new WarningIntegerParameter(name, constraint, "degrees", Integer.valueOf(value));
        param.setWarningConstraint(warnConstraint);
        param.addParameterChangeWarningListener(this);
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private Parameter makeWarningDoubleParameter() {
        String name = "Warning Double Parameter";
        String value = "1" + paramCount;
        ++paramCount;
        DoubleConstraint constraint = new DoubleConstraint(-120.0, 120.0);
        DoubleConstraint warn = new DoubleConstraint(-60.0, 60.0);
        WarningDoubleParameter param = new WarningDoubleParameter(name, constraint, "degrees", Double.valueOf(value));
        param.setWarningConstraint(warn);
        param.addParameterChangeWarningListener(this);
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private Parameter makeDoubleParameter() {
        String name = "Constrained Double Parameter";
        String value = "12." + paramCount;
        ++paramCount;
        DoubleConstraint constraint = new DoubleConstraint(0.0, 20.0);
        DoubleParameter param = new DoubleParameter(name, constraint, "acres", Double.valueOf(value));
        param.addParameterChangeFailListener(this);
        param.addParameterChangeListener(this);
        return param;
    }

    private Parameter makeStringParameter() {
        String name = "String Parameter (" + paramCount + ")";
        String value = "Value " + paramCount;
        ++paramCount;
        StringParameter param = new StringParameter(name, value);
        param.addParameterChangeListener(this);
        return param;
    }

    private Parameter makeConstrainedStringParameter(StringConstraint constraint) {
        String name = "Constrained String Parameter";
        String value = "Value " + paramCount;
        ++paramCount;
        StringParameter param = new StringParameter(name, constraint, null, "William");
        param.addParameterChangeListener(this);
        return param;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "ParameterApplet: parameterChange(): ";
        System.out.println(S + "starting: ");
        String name1 = event.getParameterName();
        String old1 = event.getOldValue().toString();
        String str1 = event.getNewValue().toString();
        String msg = "Status: " + name1 + " changed from " + old1 + " to " + str1;
        System.out.println(msg);
        this.statusLabel.setText(msg);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public static void main(String[] args) {
        Double d1 = 1.0;
        Double d2 = Double.NaN;
        Object d3 = null;
        ParameterApplet applet = new ParameterApplet();
        applet.isStandalone = true;
        applet.setDefaultCloseOperation(3);
        applet.setTitle("Applet Frame");
        applet.init();
        applet.start();
        applet.setSize(400, 320);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        applet.setLocation((d.width - applet.getSize().width) / 2, (d.height - applet.getSize().height) / 2);
        applet.setVisible(true);
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        StringBuffer b = new StringBuffer();
        b.append('\"');
        b.append(e.getParameterName());
        b.append('\"');
        b.append(" doesn't allow the value: ");
        b.append(e.getBadValue().toString());
        b.append(". \nChoose within constraints:\n");
        b.append(((Parameter)e.getSource()).getConstraint().toString());
        JOptionPane.showMessageDialog(this, b.toString(), "Cannot Change Value", 1);
    }

    @Override
    public void parameterChangeWarning(ParameterChangeWarningEvent e) {
        StringBuffer b = new StringBuffer();
        try {
            Number max;
            Number min;
            if (e.getWarningParameter().getWarningMin() instanceof Double) {
                min = (Double)e.getWarningParameter().getWarningMin();
                max = (Double)e.getWarningParameter().getWarningMax();
            } else {
                min = (Integer)e.getWarningParameter().getWarningMin();
                max = (Integer)e.getWarningParameter().getWarningMax();
            }
            String name = e.getWarningParameter().getName();
            b.append("You have exceeded the recommended range for ");
            b.append(name);
            b.append(": (");
            b.append(min.toString());
            b.append(" to ");
            b.append(max.toString());
            b.append(")\n");
            b.append("Click Yes to accept the new value: ");
            b.append(e.getNewValue().toString());
            JOptionPane.showMessageDialog(this, b.toString(), "Exceeded Recommended Values", 0);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }
}

