/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.AbstractParameterEditor;

public class BooleanParameterEditor
extends AbstractParameterEditor<Boolean>
implements ItemListener {
    private static final long serialVersionUID = 1L;
    protected static final String C = "BooleanParameterEditor";
    protected static final boolean D = false;
    private JCheckBox widget;

    public BooleanParameterEditor(Parameter<Boolean> model) {
        super(model);
    }

    @Override
    public void itemStateChanged(ItemEvent ae) {
        this.setValue(this.widget.isSelected());
    }

    @Override
    public boolean isParameterSupported(Parameter<Boolean> param) {
        if (param == null) {
            return false;
        }
        return param.getValue() instanceof Boolean;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.widget != null) {
            this.widget.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.widget != null && this.widget.isEnabled();
    }

    @Override
    protected JComponent buildWidget() {
        this.widget = new JCheckBox(this.getParameter().getName());
        this.widget.setPreferredSize(LABEL_DIM);
        this.widget.setMinimumSize(LABEL_DIM);
        this.widget.setBorder(ETCHED);
        this.widget.setSelected((Boolean)this.getParameter().getValue());
        this.widget.addItemListener(this);
        return this.widget;
    }

    @Override
    protected JComponent updateWidget() {
        this.widget.setText(this.getParameter().getName());
        this.widget.setSelected((Boolean)this.getParameter().getValue());
        return this.widget;
    }

    @Override
    protected void updateTitle() {
        super.setTitle(null);
    }
}

