/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.editor.AbstractParameterEditor;

public class ConstrainedDoubleDiscreteParameterEditor
extends AbstractParameterEditor<Double>
implements ItemListener {
    private static final long serialVersionUID = 1L;
    protected static final String C = "ConstrainedDoubleDiscreteParameterEditor";
    protected static final boolean D = false;
    private JComponent widget;

    public ConstrainedDoubleDiscreteParameterEditor() {
    }

    public ConstrainedDoubleDiscreteParameterEditor(Parameter<Double> model) throws ConstraintException {
        super(model);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String S = "ConstrainedDoubleDiscreteParameterEditor: itemStateChanged(): ";
        Double value = (Double)((JComboBox)this.widget).getSelectedItem();
        this.setValue(value);
    }

    @Override
    public boolean isParameterSupported(Parameter<Double> param) {
        if (param == null) {
            return false;
        }
        if (!(param.getValue() instanceof Double)) {
            return false;
        }
        ParameterConstraint constraint = param.getConstraint();
        if (constraint == null) {
            return false;
        }
        if (constraint.isNullAllowed()) {
            return false;
        }
        if (!(constraint instanceof DoubleDiscreteConstraint)) {
            return false;
        }
        DoubleDiscreteConstraint dconst = (DoubleDiscreteConstraint)constraint;
        int numConstriants = dconst.size();
        return numConstriants >= 1;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.widget != null) {
            this.widget.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.widget != null && this.widget.isEnabled();
    }

    @Override
    protected JComponent buildWidget() {
        DoubleDiscreteConstraint con = (DoubleDiscreteConstraint)this.getParameter().getConstraint();
        List<Double> vals = con.getAllowedDoubles();
        if (vals.size() > 1) {
            JComboBox<Object> combo = new JComboBox<Object>(vals.toArray());
            combo.setMaximumRowCount(32);
            this.widget = combo;
            this.widget.setPreferredSize(WIGET_PANEL_DIM);
            this.widget.setMinimumSize(WIGET_PANEL_DIM);
            combo.setSelectedIndex(vals.indexOf(this.getParameter().getValue()));
            combo.addItemListener(this);
        } else {
            JLabel label = ConstrainedDoubleDiscreteParameterEditor.makeSingleConstraintValueLabel(vals.get(0).toString());
            this.widget = new JPanel(new BorderLayout());
            this.widget.setBackground(Color.LIGHT_GRAY);
            this.widget.add(label);
        }
        return this.widget;
    }

    @Override
    protected JComponent updateWidget() {
        DoubleDiscreteConstraint con = (DoubleDiscreteConstraint)this.getParameter().getConstraint();
        List<Double> vals = con.getAllowedDoubles();
        if (vals.size() > 1) {
            if (this.widget instanceof JComboBox) {
                JComboBox combo = (JComboBox)this.widget;
                combo.removeItemListener(this);
                combo.setModel(new DefaultComboBoxModel<Object>(vals.toArray()));
                combo.setSelectedIndex(vals.indexOf(this.getParameter().getValue()));
                combo.addItemListener(this);
                return this.widget;
            }
            return this.buildWidget();
        }
        return this.buildWidget();
    }
}

