/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.Color;
import javax.swing.JComponent;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.param.constraint.impl.IntegerConstraint;
import org.opensha.commons.param.editor.impl.IntegerParameterEditor;
import org.opensha.commons.param.editor.impl.IntegerTextField;
import org.opensha.commons.util.ParamUtils;

public class ConstrainedIntegerParameterEditor
extends IntegerParameterEditor {
    private static final long serialVersionUID = 1L;
    protected static final String C = "ConstrainedIntegerParameterEditor";
    protected static final boolean D = false;
    private Color origFG;

    public ConstrainedIntegerParameterEditor() {
    }

    public ConstrainedIntegerParameterEditor(Parameter model) throws Exception {
        super(model);
        this.setParameter(model);
    }

    @Override
    protected JComponent buildWidget() {
        IntegerConstraint constraint;
        IntegerTextField comp = (IntegerTextField)super.buildWidget();
        if (this.origFG == null) {
            this.origFG = comp.getForeground();
        }
        if ((constraint = this.getConstraint()).getMax().equals(constraint.getMin())) {
            comp.setEditable(false);
            comp.setForeground(Color.blue);
        }
        return comp;
    }

    @Override
    protected JComponent updateWidget() {
        IntegerTextField comp = (IntegerTextField)super.updateWidget();
        IntegerConstraint constraint = this.getConstraint();
        if (constraint.getMax().equals(constraint.getMin())) {
            comp.setEditable(false);
            comp.setForeground(Color.blue);
        } else {
            comp.setEditable(true);
            comp.setForeground(this.origFG);
        }
        return comp;
    }

    protected IntegerConstraint getConstraint() {
        IntegerConstraint constraint;
        Parameter param = this.getParameter();
        if (ParamUtils.isWarningParameterAPI(param)) {
            constraint = (IntegerConstraint)((WarningParameter)param).getWarningConstraint();
            if (constraint == null) {
                constraint = (IntegerConstraint)param.getConstraint();
            }
        } else {
            constraint = (IntegerConstraint)param.getConstraint();
        }
        return constraint;
    }

    @Override
    protected String getWidgetToolTipText() {
        IntegerConstraint constraint = this.getConstraint();
        Object text = super.getWidgetToolTipText();
        text = text == null || ((String)text).length() == 0 ? "" : (String)text + "\n";
        text = (String)text + "Min = " + constraint.getMin().toString() + "; Max = " + constraint.getMax().toString();
        return text;
    }
}

