/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.gui.WeightedListGUI;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.impl.WeightedListParameter;

public class WeightedListParameterEditor
extends AbstractParameterEditor<WeightedList<?>>
implements ComponentListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private boolean isGuiMode;
    private JButton editButton;
    private WeightedListGUI gui;
    private JDialog guiDialog;
    private JButton dialogOKButton;

    public WeightedListParameterEditor() {
    }

    public WeightedListParameterEditor(Parameter model) {
        super(model);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.gui.setEnabled(isEnabled);
    }

    @Override
    public boolean isEnabled() {
        return this.gui != null && this.gui.isEnabled();
    }

    public static void main(String[] args) {
        ArrayList<String> objects = new ArrayList<String>();
        ArrayList<Double> weights = new ArrayList<Double>();
        objects.add("item 1");
        weights.add(0.25);
        objects.add("item 2");
        weights.add(0.25);
        objects.add("item 3");
        weights.add(0.25);
        objects.add("item 4");
        weights.add(0.25);
        WeightedList list = new WeightedList(objects, weights);
        WeightedListParameter param = new WeightedListParameter("my param", list);
        JFrame frame = new JFrame();
        frame.setSize(400, 600);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new WeightedListParameterEditor((Parameter)param));
        frame.setVisible(true);
    }

    @Override
    public boolean isParameterSupported(Parameter<WeightedList<?>> param) {
        if (param == null) {
            return false;
        }
        return param.getValue() instanceof WeightedList;
    }

    @Override
    protected JComponent buildWidget() {
        if (this.gui == null) {
            this.gui = new WeightedListGUI(this.getList());
            this.addComponentListener(this);
            this.editButton = new JButton("Edit Weights");
            this.editButton.addActionListener(this);
        }
        return this.updateWidget();
    }

    private WeightedList<?> getList() {
        Parameter param = this.getParameter();
        if (param == null) {
            return null;
        }
        return (WeightedList)param.getValue();
    }

    private boolean shouldGuiBeVisible() {
        return this.getSize().getWidth() > 250.0;
    }

    @Override
    protected JComponent updateWidget() {
        this.gui.setList(this.getList());
        if (this.shouldGuiBeVisible()) {
            this.isGuiMode = true;
            return this.gui;
        }
        this.isGuiMode = false;
        return this.editButton;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.isGuiMode != this.shouldGuiBeVisible()) {
            this.refreshParamEditor();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private void buildDialog() {
        this.dialogOKButton = new JButton("Done");
        this.dialogOKButton.addActionListener(this);
        JPanel dialogPanel = new JPanel(new BorderLayout());
        dialogPanel.add((Component)this.gui, "Center");
        dialogPanel.add((Component)this.dialogOKButton, "South");
        this.guiDialog = new JDialog();
        this.guiDialog.setModal(true);
        this.guiDialog.setContentPane(dialogPanel);
        this.guiDialog.setSize(300, 400);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.editButton) {
            if (this.guiDialog == null) {
                this.buildDialog();
            }
            this.guiDialog.setTitle(this.getTitle());
            this.guiDialog.setVisible(true);
        } else if (e.getSource() == this.dialogOKButton) {
            this.guiDialog.setVisible(false);
        }
    }
}

