/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.impl;

import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedDoubleParameterEditor;
import org.opensha.commons.param.editor.impl.DoubleParameterEditor;

public class DoubleParameter
extends AbstractParameter<Double> {
    private static final long serialVersionUID = 1L;
    protected static final String C = "DoubleParameter";
    protected static final boolean D = false;
    private transient ParameterEditor<Double> paramEdit = null;

    public DoubleParameter(String name) {
        super(name, null, null, null);
    }

    public DoubleParameter(String name, String units) {
        super(name, null, units, null);
    }

    public DoubleParameter(String name, double min, double max) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), null, null);
    }

    public DoubleParameter(String name, double min, double max, String units) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), units, null);
    }

    public DoubleParameter(String name, Double min, Double max) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), null, null);
    }

    public DoubleParameter(String name, Double min, Double max, String units) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), units, null);
    }

    public DoubleParameter(String name, DoubleConstraint constraint) throws ConstraintException {
        super(name, constraint, null, null);
    }

    public DoubleParameter(String name, DoubleConstraint constraint, String units) throws ConstraintException {
        super(name, constraint, units, null);
    }

    public DoubleParameter(String name, Double value) {
        super(name, null, null, value);
    }

    public DoubleParameter(String name, String units, Double value) throws ConstraintException {
        super(name, null, units, value);
    }

    public DoubleParameter(String name, double min, double max, Double value) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), null, value);
    }

    public DoubleParameter(String name, Double min, Double max, Double value) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), null, value);
    }

    public DoubleParameter(String name, DoubleConstraint constraint, Double value) throws ConstraintException {
        super(name, constraint, null, value);
    }

    public DoubleParameter(String name, double min, double max, String units, Double value) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), units, value);
    }

    public DoubleParameter(String name, Double min, Double max, String units, Double value) throws ConstraintException {
        super(name, new DoubleConstraint(min, max), units, value);
    }

    public DoubleParameter(String name, DoubleConstraint constraint, String units, Double value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    @Override
    public void setConstraint(ParameterConstraint constraint) throws ParameterException, EditableException {
        String S = "DoubleParameter: setConstraint(): ";
        this.checkEditable(S);
        if (!(constraint instanceof DoubleConstraint)) {
            throw new ParameterException(S + "This parameter only accepts DoubleConstraints, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    public Double getMin() throws Exception {
        if (this.constraint != null) {
            return ((DoubleConstraint)this.constraint).getMin();
        }
        return null;
    }

    public Double getMax() {
        if (this.constraint != null) {
            return ((DoubleConstraint)this.constraint).getMax();
        }
        return null;
    }

    @Override
    public String getType() {
        Object type = C;
        ParameterConstraint constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + (String)type;
        }
        return type;
    }

    @Override
    public void setValue(double value) throws ConstraintException, ParameterException {
        this.setValue(Double.valueOf(value));
    }

    @Override
    public boolean isAllowed(Double d) {
        if (this.constraint != null) {
            return this.constraint.isAllowed(d);
        }
        return true;
    }

    @Override
    public Object clone() {
        DoubleConstraint c1 = null;
        if (this.constraint != null) {
            c1 = (DoubleConstraint)this.constraint.clone();
        }
        DoubleParameter param = null;
        param = this.value == null ? new DoubleParameter(this.name, c1, this.units) : new DoubleParameter(this.name, c1, this.units, Double.valueOf(((Double)this.value).toString()));
        if (param == null) {
            return null;
        }
        param.editable = true;
        param.info = this.info;
        return param;
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        try {
            Double val = Double.parseDouble(el.attributeValue("value"));
            this.setValue(val);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public ParameterEditor<Double> getEditor() {
        if (this.paramEdit == null) {
            try {
                this.paramEdit = this.constraint == null ? new DoubleParameterEditor((Parameter)this) : new ConstrainedDoubleParameterEditor((Parameter)this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.paramEdit;
    }

    @Override
    public boolean isEditorBuilt() {
        return this.paramEdit != null;
    }
}

