/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.impl;

import java.util.ArrayList;
import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.editor.impl.StringParameterEditor;

public class StringParameter
extends AbstractParameter<String> {
    private static final long serialVersionUID = 1L;
    protected static final String C = "StringParameter";
    protected static final boolean D = false;
    private transient ParameterEditor<String> paramEdit = null;

    public StringParameter(String name) {
        this(name, null, null, null);
    }

    public StringParameter(String name, ArrayList strings) throws ConstraintException {
        this(name, new StringConstraint(strings), null, null);
    }

    public StringParameter(String name, StringConstraint constraint) throws ConstraintException {
        this(name, constraint, null, null);
    }

    public StringParameter(String name, String value) {
        this(name, null, null, value);
    }

    public StringParameter(String name, String units, String value) throws ConstraintException {
        this(name, null, units, value);
    }

    public StringParameter(String name, ArrayList strings, String value) throws ConstraintException {
        this(name, new StringConstraint(strings), null, value);
    }

    public StringParameter(String name, StringConstraint constraint, String value) throws ConstraintException {
        this(name, constraint, null, value);
    }

    public StringParameter(String name, StringConstraint constraint, String units, String value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    @Override
    public void setConstraint(ParameterConstraint constraint) throws ParameterException, EditableException {
        String S = "StringParameter: setConstraint(): ";
        this.checkEditable(S);
        if (!(constraint instanceof StringConstraint)) {
            throw new ParameterException(S + "This parameter only accepts StringConstraints, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    @Override
    public String getType() {
        Object type = C;
        ParameterConstraint constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + (String)type;
        }
        return type;
    }

    public ArrayList<String> getAllowedStrings() {
        return ((StringConstraint)this.constraint).getAllowedStrings();
    }

    @Override
    public Object clone() {
        StringConstraint c1 = null;
        if (this.constraint != null) {
            c1 = (StringConstraint)this.constraint.clone();
        }
        StringParameter param = null;
        if (this.value == null) {
            param = new StringParameter(this.name, c1);
            param.setUnits(this.units);
        } else {
            param = new StringParameter(this.name, c1, this.units, ((String)this.value).toString());
        }
        if (param == null) {
            return null;
        }
        param.editable = true;
        param.info = this.info;
        return param;
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        String val = el.attributeValue("value");
        if (val.length() == 0) {
            try {
                this.setValue("");
            }
            catch (ConstraintException e) {
                System.err.println("Warning: could not set String Param to empty string from XML");
            }
            catch (ParameterException e) {
                System.err.println("Warning: could not set String Param to empty string from XML");
            }
        } else {
            this.setValue(val);
        }
        return true;
    }

    @Override
    public ParameterEditor<String> getEditor() {
        if (this.paramEdit == null) {
            if (this.constraint == null) {
                try {
                    this.paramEdit = new StringParameterEditor((Parameter)this);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.paramEdit = new ConstrainedStringParameterEditor(this);
            }
        }
        return this.paramEdit;
    }

    @Override
    public boolean isEditorBuilt() {
        return this.paramEdit != null;
    }
}

