/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.opensha.commons.util.FileUtils;

@JsonAdapter(value=Adapter.class)
public class ApplicationVersion
implements Comparable<ApplicationVersion> {
    private int major;
    private int minor;
    private int build;
    private static final String[] possible_version_files = new String[]{"ant/include/build.version", "build.version", "../opensha/build.version"};
    private static final String[] possible_version_resources = new String[]{"/ant/include/build.version", "/build.version"};

    public ApplicationVersion(int major, int minor, int build) {
        this.major = major;
        this.minor = minor;
        this.build = build;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getBuild() {
        return this.build;
    }

    public void setBuild(int build) {
        this.build = build;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.build;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationVersion other = (ApplicationVersion)obj;
        if (this.build != other.build) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        return this.minor == other.minor;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.build;
    }

    public static ApplicationVersion fromString(String str) {
        String[] split = str.split("\\.");
        if (split.length < 2 || split.length > 3) {
            throw new IllegalArgumentException("Version string must have 2 or 3 period separated version numbers");
        }
        int major = Integer.parseInt(split[0]);
        int minor = Integer.parseInt(split[1]);
        int build = 0;
        if (split.length == 3) {
            build = Integer.parseInt(split[2]);
        }
        return new ApplicationVersion(major, minor, build);
    }

    @Override
    public int compareTo(ApplicationVersion o) {
        int val = Integer.valueOf(this.getMajor()).compareTo(o.getMajor());
        if (val != 0) {
            return val;
        }
        val = Integer.valueOf(this.getMinor()).compareTo(o.getMinor());
        if (val != 0) {
            return val;
        }
        val = Integer.valueOf(this.getBuild()).compareTo(o.getBuild());
        return val;
    }

    public boolean isGreaterThan(ApplicationVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean isLessThan(ApplicationVersion other) {
        return this.compareTo(other) < 0;
    }

    private static URL getVersionFile() throws FileNotFoundException {
        return ApplicationVersion.locateURL(possible_version_files, possible_version_resources);
    }

    private static URL locateURL(String[] possible_files, String[] possible_resources) throws FileNotFoundException {
        URL url = null;
        for (String fileName : possible_files) {
            try {
                url = new URL("file:" + fileName);
                if (new File(fileName.replace('/', File.separatorChar)).exists()) {
                    return url;
                }
                url = null;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        for (String resource : possible_resources) {
            try {
                url = ApplicationVersion.class.getResource(resource);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (url == null) continue;
            return url;
        }
        throw new FileNotFoundException("Couldn't locate build version file!");
    }

    public static ApplicationVersion loadBuildVersion() throws IOException {
        return ApplicationVersion.loadBuildVersion(ApplicationVersion.getVersionFile());
    }

    public static ApplicationVersion loadBuildVersion(URL versionFile) throws IOException {
        int major = 0;
        int minor = 0;
        int build = 0;
        for (String line : FileUtils.loadFile(versionFile)) {
            if (line.startsWith("#") || !line.contains("=")) continue;
            String[] split = (line = line.trim()).split("=");
            if (split.length != 2) {
                System.err.println("Incorrectly formatted line: " + line);
                continue;
            }
            if (split[0].equals("major.version")) {
                major = Integer.parseInt(split[1]);
                continue;
            }
            if (split[0].equals("minor.version")) {
                minor = Integer.parseInt(split[1]);
                continue;
            }
            if (split[0].equals("build.number")) {
                build = Integer.parseInt(split[1]);
                continue;
            }
            System.err.println("Unknown key: " + split[0]);
        }
        return new ApplicationVersion(major, minor, build);
    }

    private static void testCompare(ApplicationVersion v1, ApplicationVersion v2) {
        System.out.println("Comparing " + String.valueOf(v1) + " to " + String.valueOf(v2));
        System.out.println(String.valueOf(v1) + " > " + String.valueOf(v2) + " ? " + v1.isGreaterThan(v2));
        System.out.println(String.valueOf(v1) + " < " + String.valueOf(v2) + " ? " + v1.isLessThan(v2));
        System.out.println(String.valueOf(v1) + " == " + String.valueOf(v2) + " ? " + v1.equals(v2));
    }

    public static void main(String[] args) throws IOException {
        System.exit(0);
        System.out.println(ApplicationVersion.loadBuildVersion());
        System.out.println(ApplicationVersion.fromString("0.4.2"));
        System.out.println(ApplicationVersion.fromString("0.4"));
        System.out.println("---sort test---");
        ArrayList<ApplicationVersion> versions = new ArrayList<ApplicationVersion>();
        versions.add(ApplicationVersion.fromString("0.4.2"));
        versions.add(ApplicationVersion.fromString("0.4"));
        versions.add(ApplicationVersion.fromString("2.4.2"));
        versions.add(ApplicationVersion.fromString("0.0.0"));
        versions.add(ApplicationVersion.fromString("0.3.1"));
        versions.add(ApplicationVersion.fromString("0.57.2"));
        versions.add(ApplicationVersion.fromString("1.57.2"));
        Collections.sort(versions);
        for (ApplicationVersion version : versions) {
            System.out.println(version);
        }
        ApplicationVersion.testCompare((ApplicationVersion)versions.get(0), (ApplicationVersion)versions.get(1));
        ApplicationVersion.testCompare((ApplicationVersion)versions.get(1), (ApplicationVersion)versions.get(0));
        ApplicationVersion.testCompare((ApplicationVersion)versions.get(1), (ApplicationVersion)versions.get(4));
        ApplicationVersion.testCompare((ApplicationVersion)versions.get(4), (ApplicationVersion)versions.get(1));
        ApplicationVersion.testCompare((ApplicationVersion)versions.get(0), (ApplicationVersion)versions.get(0));
        ApplicationVersion.testCompare((ApplicationVersion)versions.get(4), (ApplicationVersion)versions.get(4));
    }

    public static class Adapter
    extends TypeAdapter<ApplicationVersion> {
        public void write(JsonWriter out, ApplicationVersion value) throws IOException {
            out.value(value.toString());
        }

        public ApplicationVersion read(JsonReader in) throws IOException {
            return ApplicationVersion.fromString(in.nextString());
        }
    }
}

