/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class DeadlockDetectionThread
extends Thread {
    private long checkMillis;
    private ThreadMXBean tmx;
    private boolean killed = false;

    public DeadlockDetectionThread(long checkMillis) {
        this.checkMillis = checkMillis;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        this.killed = false;
        if (this.tmx == null) {
            this.tmx = ManagementFactory.getThreadMXBean();
        }
        while (!this.killed) {
            long[] ids = this.tmx.findDeadlockedThreads();
            if (ids != null) {
                ThreadInfo[] infos = this.tmx.getThreadInfo(ids, true, true);
                System.out.println("The following threads are deadlocked:");
                for (ThreadInfo ti : infos) {
                    System.out.println(ti);
                }
            }
            try {
                Thread.sleep(this.checkMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void kill() {
        this.killed = true;
    }
}

