/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.opensha.commons.util.FileUtils;

public class GitVersion {
    final String filePrefix;
    final File baseDirectory;

    public GitVersion() {
        this(new File(""), "/build");
    }

    public GitVersion(File baseDirectory, String filePrefix) {
        this.baseDirectory = baseDirectory.getAbsoluteFile();
        this.filePrefix = filePrefix;
    }

    public static String first(List<String> lines) {
        if (lines == null) {
            return null;
        }
        for (String line : lines) {
            if ((line = line.trim()).isEmpty()) continue;
            return line;
        }
        return null;
    }

    public static List<String> execute(String[] command, File directory) {
        try {
            Process p = Runtime.getRuntime().exec(command, null, directory);
            int exit = p.waitFor();
            if (exit != 0) {
                return null;
            }
            return FileUtils.loadStream(p.getInputStream());
        }
        catch (Exception e) {
            System.err.println("Exception executing command " + String.join((CharSequence)" ", command) + " : " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public String loadGitHash() throws IOException {
        String gitHashFile = this.filePrefix + ".githash";
        try {
            String gitHash;
            URL url = GitVersion.class.getResource(gitHashFile);
            if (url != null && (gitHash = GitVersion.first(FileUtils.loadFile(url))) != null) {
                return gitHash;
            }
        }
        catch (FileNotFoundException x) {
            System.out.println(gitHashFile + " resource not found");
        }
        String[] command = new String[]{"git", "rev-parse", "HEAD"};
        return GitVersion.first(GitVersion.execute(command, this.baseDirectory));
    }

    public String loadGitBranch() throws IOException {
        String gitBranchFileName = this.filePrefix + ".gitbranch";
        try {
            String branch;
            URL url = GitVersion.class.getResource(gitBranchFileName);
            if (url != null && (branch = GitVersion.first(FileUtils.loadFile(url))) != null) {
                return branch;
            }
        }
        catch (FileNotFoundException x) {
            System.out.println(gitBranchFileName + " resource not found.");
        }
        File cwd = new File("").getAbsoluteFile();
        String[] command = new String[]{"git", "rev-parse", "--abbrev-ref", "HEAD"};
        return GitVersion.first(GitVersion.execute(command, cwd));
    }

    public String loadGitRemote() throws IOException {
        String branch;
        String gitBranchFileName = this.filePrefix + ".gitremoteurl";
        try {
            URL url = GitVersion.class.getResource(gitBranchFileName);
            if (url != null && (branch = GitVersion.first(FileUtils.loadFile(url))) != null) {
                return branch;
            }
        }
        catch (FileNotFoundException x) {
            System.out.println(gitBranchFileName + " resource not found.");
        }
        String[] command = new String[]{"git", "name-rev", "--name-only", "HEAD"};
        branch = GitVersion.first(GitVersion.execute(command, this.baseDirectory));
        command = new String[]{"git", "config", "branch." + branch + ".remote"};
        String remote = GitVersion.first(GitVersion.execute(command, this.baseDirectory));
        command = new String[]{"git", "config", "remote." + remote + ".url"};
        return GitVersion.first(GitVersion.execute(command, this.baseDirectory));
    }

    public Date loadBuildDate() throws IOException {
        URL url = GitVersion.class.getResource(this.filePrefix + ".date");
        if (url == null) {
            return null;
        }
        for (String line : FileUtils.loadFile(url)) {
            long date;
            if (!NumberUtils.isParsable((String)line) || (date = Long.parseLong(line)) <= 0L) continue;
            return new Date(date);
        }
        return null;
    }

    public Map<String, String> getMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String gitHash = this.loadGitHash();
            if (gitHash != null) {
                result.put("gitHash", gitHash);
            }
        }
        catch (IOException gitHash) {
            // empty catch block
        }
        try {
            String branch = this.loadGitBranch();
            if (branch != null) {
                result.put("branch", branch);
            }
        }
        catch (IOException branch) {
            // empty catch block
        }
        try {
            Date buildDate = this.loadBuildDate();
            if (buildDate != null) {
                String buildTime = this.loadBuildDate().toString();
                result.put("buildTime", buildTime);
            }
        }
        catch (IOException buildDate) {
            // empty catch block
        }
        try {
            String remoteUrl = this.loadGitRemote();
            if (remoteUrl != null) {
                result.put("remoteUrl", remoteUrl);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        GitVersion git = new GitVersion();
        System.out.println(git.loadGitBranch());
        System.out.println(git.loadGitRemote());
        System.out.println(git.loadGitHash());
        System.out.println(git.loadBuildDate());
    }
}

