/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class IconGen {
    private static final String resourcesDir = "/images";
    private static final String shareURL = "http://opensha.usc.edu/shared";
    private Map<int[], ? extends Image> backgrounds;
    private String text;
    private String fontName;
    private Color outlineColor;
    private Color fillColor;
    private Image upperRight = null;
    private static HashMap<int[], BufferedImage> logoBackground = null;

    private static HashMap<int[], ? extends Image> wrapInMap(Image image) {
        HashMap<int[], Image> map = new HashMap<int[], Image>();
        int[] size = new int[]{image.getWidth(null), image.getHeight(null)};
        map.put(size, image);
        return map;
    }

    public IconGen(Image background, String text, String fontName, Color fillColor, Color outlineColor) {
        this(IconGen.wrapInMap(background), text, fontName, fillColor, outlineColor);
    }

    public IconGen(Map<int[], ? extends Image> backgrounds, String text, String fontName, Color fillColor, Color outlineColor) {
        this.backgrounds = backgrounds;
        if (text.length() > 3) {
            System.err.println("WARNING: Text might render off image!");
        }
        this.text = text;
        this.fontName = fontName;
        this.outlineColor = outlineColor;
        this.fillColor = fillColor;
    }

    public static BufferedImage loadLocalIcon() throws IOException {
        return ImageIO.read(IconGen.class.getResourceAsStream("/images/icons/laptop.png"));
    }

    public static BufferedImage loadServerIcon() throws IOException {
        return ImageIO.read(IconGen.class.getResourceAsStream("/images/icons/server.png"));
    }

    public static HashMap<int[], BufferedImage> loadLogoIcon() throws IOException {
        if (logoBackground == null) {
            int[] sizes;
            logoBackground = new HashMap();
            for (int width : sizes = new int[]{16, 32, 64, 128}) {
                int[] size = new int[]{width, width};
                String url = "http://opensha.usc.edu/shared/opensha_" + width + ".png";
                logoBackground.put(size, ImageIO.read(new URL(url)));
            }
        }
        return logoBackground;
    }

    public void setUpperRightImage(Image upperRight) {
        this.upperRight = upperRight;
    }

    private Image getBackground(int width, int height) {
        Image biggest = null;
        int[] biggestSize = null;
        for (int[] size : this.backgrounds.keySet()) {
            if (size[0] == width && size[1] == height) {
                return this.backgrounds.get(size);
            }
            if (biggestSize != null && size[0] <= biggestSize[0]) continue;
            biggestSize = size;
            biggest = this.backgrounds.get(size);
        }
        return biggest;
    }

    public BufferedImage getIcon(int width, int height) {
        System.out.println("Creating icon with dimensions " + width + "x" + height);
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(this.getBackground(width, height), 0, 0, width, height, null);
        if (this.upperRight != null) {
            int urWidth = (int)((double)width * 0.5 + 0.5);
            int urX = (int)((double)width * 0.5 + 0.5);
            int urY = (int)((double)height * 0.5 - (double)urWidth + 0.5);
            System.out.println("placing image at " + urX + "," + urY + ", width=" + urWidth);
            g.drawImage(this.upperRight, urX, urY, urWidth, urWidth, null);
        }
        if (this.text != null && this.text.trim().length() > 0) {
            this.text = this.text.trim();
            int baseSize = this.text.length() > 2 ? 20 : 28;
            int fontSize = (int)((double)baseSize * (double)height / 64.0 + 0.5);
            Font font = new Font(this.fontName, 1, fontSize);
            boolean drawOutline = width >= 32;
            int disp = 1 * width / 16;
            if (disp < 1) {
                disp = 1;
            }
            Color textColor = drawOutline ? this.fillColor : this.outlineColor;
            g.setFont(font);
            g.setColor(textColor);
            g.drawString(this.text, disp, height - disp);
            if (drawOutline) {
                FontRenderContext frc = g.getFontRenderContext();
                TextLayout textTl = new TextLayout(this.text, font, frc);
                Shape outline = textTl.getOutline(null);
                g.translate(disp, height - disp);
                g.setColor(this.outlineColor);
                g.draw(outline);
            }
        }
        return image;
    }

    public static void main(String[] args) throws IOException {
        int[] sizes;
        String text = "GMT";
        IconGen gen = new IconGen(IconGen.loadLogoIcon(), text, "SansSerif", Color.WHITE, Color.BLACK);
        gen.setUpperRightImage(IconGen.loadLocalIcon());
        for (int size : sizes = new int[]{16, 32, 64, 128}) {
            BufferedImage icon = gen.getIcon(size, size);
            ImageIO.write((RenderedImage)icon, "png", new File("/tmp/icon_" + size + ".png"));
        }
    }
}

