/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.opensha.commons.util.ExceptionUtils;

public class LogPrintStream
extends PrintStream {
    private FileWriter fw;

    public LogPrintStream(OutputStream stream, FileWriter fw) {
        super(stream);
        this.fw = fw;
    }

    @Override
    public void write(int i) {
        super.write(i);
        try {
            this.fw.write(i);
        }
        catch (IOException e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
    }

    @Override
    public void write(byte[] bytes, int i, int j) {
        super.write(bytes, i, j);
        try {
            this.fw.write(new String(bytes, i, j));
        }
        catch (IOException e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        super.write(bytes);
        try {
            this.fw.write(new String(bytes));
        }
        catch (IOException e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
    }
}

