/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public class NtoNMap<Left, Right> {
    private HashMap<Left, Collection<Right>> leftToRightMap = new HashMap();
    private HashMap<Right, Collection<Left>> rightToLeftMap = new HashMap();
    private int size = 0;

    public void clear() {
        this.leftToRightMap.clear();
        this.rightToLeftMap.clear();
        this.size = 0;
    }

    public void put(Left leftElem, Right rightElem) {
        Collection<Right> rights = this.leftToRightMap.get(leftElem);
        Collection<Left> lefts = this.rightToLeftMap.get(rightElem);
        if (lefts == null) {
            lefts = new ArrayList<Left>();
            this.rightToLeftMap.put(rightElem, lefts);
        }
        if (rights == null) {
            rights = new ArrayList<Right>();
            this.leftToRightMap.put(leftElem, rights);
        }
        if (!lefts.contains(leftElem) && !rights.contains(rightElem)) {
            lefts.add(leftElem);
            rights.add(rightElem);
            ++this.size;
        }
    }

    public void putAll(NtoNMap<Left, Right> map) {
        for (Left one : map.getLefts()) {
            for (Right two : map.getRights(one)) {
                this.put(one, two);
            }
        }
    }

    public Set<Left> getLefts() {
        return this.leftToRightMap.keySet();
    }

    public Collection<Left> getLefts(Right two) {
        return this.rightToLeftMap.get(two);
    }

    public Set<Right> getRights() {
        return this.rightToLeftMap.keySet();
    }

    public Collection<Right> getRights(Left one) {
        return this.leftToRightMap.get(one);
    }

    public boolean containsMapping(Left left, Right right) {
        Collection<Left> lefts = this.getLefts(right);
        if (lefts == null) {
            return false;
        }
        for (Left leftTest : lefts) {
            if (!leftTest.equals(left)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean remove(Left left, Right right) {
        Collection<Left> lefts = this.getLefts(right);
        Collection<Right> rights = this.getRights(left);
        if (lefts != null && rights != null && lefts.contains(left) && rights.contains(right)) {
            boolean success;
            boolean bl = success = lefts.remove(left) && rights.remove(right);
            if (success) {
                --this.size;
                return true;
            }
        }
        return false;
    }
}

