/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.binFile;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import org.opensha.commons.util.binFile.BinaryRandomAccessFile;

public class BinaryDoubleScalarRandomAccessFile
extends BinaryRandomAccessFile {
    private BinaryRandomAccessFile.BufferWrapper<DoubleBuffer> singleDoubleBuffer;
    private double placeholder = Double.NaN;

    public BinaryDoubleScalarRandomAccessFile(File file, int numVals) {
        this(file, ByteOrder.BIG_ENDIAN, numVals);
    }

    public BinaryDoubleScalarRandomAccessFile(File file, ByteOrder byteOrder, int numVals) {
        super(file, byteOrder, numVals);
        this.singleDoubleBuffer = this.getDoubleBuffer(1);
    }

    public void setPlaceholder(double placeholder) {
        this.placeholder = placeholder;
    }

    public synchronized void write(int index, double val) throws IOException {
        ((DoubleBuffer)this.singleDoubleBuffer.buffer).put(0, val);
        this.writeRecord(index, BinaryDoubleScalarRandomAccessFile.cloneBytes(this.singleDoubleBuffer.getBytes()));
    }

    @Override
    protected int getHeaderLen() {
        return 4;
    }

    @Override
    protected int getRecordLen() {
        return 8;
    }

    @Override
    protected byte[] getHeader() {
        BinaryRandomAccessFile.BufferWrapper<IntBuffer> wrap = this.getIntBuffer(1);
        ((IntBuffer)wrap.buffer).put(0, this.getNumRecords());
        return BinaryDoubleScalarRandomAccessFile.cloneBytes(wrap.bytes);
    }

    @Override
    protected synchronized byte[] getBlankRecord() {
        ((DoubleBuffer)this.singleDoubleBuffer.buffer).put(0, this.placeholder);
        return BinaryDoubleScalarRandomAccessFile.cloneBytes(this.singleDoubleBuffer.bytes);
    }

    public synchronized boolean isCalculated(int index) throws IOException {
        byte[] record = this.readRecord(index);
        for (int i = 0; i < record.length; ++i) {
            this.singleDoubleBuffer.getBytes()[i] = record[i];
        }
        double val = this.singleDoubleBuffer.getBuffer().get(0);
        if (Double.isNaN(this.placeholder)) {
            return !Double.isNaN(val);
        }
        return val != this.placeholder;
    }

    public static double[] readFile(File file) throws IOException {
        long length = file.length();
        Preconditions.checkState((length > 0L ? 1 : 0) != 0, (Object)"file is empty!");
        Preconditions.checkState(((length - 4L) % 8L == 0L ? 1 : 0) != 0, (Object)"file size after header isn't evenly divisible by 8, thus not a sequence of double values.");
        InputStream is = new FileInputStream(file);
        Preconditions.checkNotNull((Object)is, (Object)"InputStream cannot be null!");
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        DataInputStream in = new DataInputStream(is);
        int size = in.readInt();
        double[] array = new double[size];
        for (int i = 0; i < size; ++i) {
            array[i] = in.readDouble();
        }
        in.close();
        return array;
    }
}

