/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.modules;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensha.commons.util.modules.ModuleContainer;
import org.opensha.commons.util.modules.ModuleHelper;
import org.opensha.commons.util.modules.OpenSHA_Module;

@ModuleHelper
public interface AverageableModule<E extends AverageableModule<E>>
extends OpenSHA_Module {
    public AveragingAccumulator<E> averagingAccumulator();

    default public E getAverage(Collection<E> modules) {
        return this.getAverage(new ArrayList<E>(modules), null);
    }

    default public E getAverage(List<E> modules, List<Double> relWeights) {
        Preconditions.checkState((modules.size() > 0 ? 1 : 0) != 0, (Object)"Must supply at least 1 module");
        Preconditions.checkState((relWeights == null || relWeights.size() == modules.size() ? 1 : 0) != 0);
        AveragingAccumulator<AverageableModule> accumulator = this.averagingAccumulator();
        for (int i = 0; i < modules.size(); ++i) {
            AverageableModule module = (AverageableModule)modules.get(i);
            double relWeight = relWeights == null ? 1.0 / (double)modules.size() : relWeights.get(i);
            accumulator.process(module, relWeight);
        }
        return (E)((AverageableModule)accumulator.getAverage());
    }

    public static void scaleToTotalWeight(double[] values, double totWeight) {
        Preconditions.checkState((totWeight > 0.0 ? 1 : 0) != 0);
        if (totWeight == 1.0) {
            return;
        }
        double scale = 1.0 / totWeight;
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] * scale;
        }
    }

    public static interface AveragingAccumulator<E extends OpenSHA_Module> {
        public Class<E> getType();

        default public void processContainer(ModuleContainer<? super E> container, double relWeight) throws IllegalStateException {
            this.process(container.requireModule(this.getType()), relWeight);
        }

        public void process(E var1, double var2);

        public E getAverage();
    }

    @ModuleHelper
    public static interface ConstantAverageable<E extends AverageableModule<E>>
    extends AverageableModule<E> {
        public Class<E> getAveragingType();

        public boolean isIdentical(E var1);

        @Override
        default public AveragingAccumulator<E> averagingAccumulator() {
            return new AveragingAccumulator<E>(){
                private E module;

                @Override
                public void process(E module, double relWeight) {
                    Preconditions.checkState((boolean)this.isIdentical(module), (String)"Averaging a ConstantAverageable instance but encountered a version (%s) that is not identical to the original instance (%s).", module, (Object)this);
                    if (this.module == null) {
                        this.module = module;
                    }
                }

                @Override
                public E getAverage() {
                    Preconditions.checkNotNull(this.module);
                    return this.module;
                }

                @Override
                public Class<E> getType() {
                    return this.getAveragingType();
                }
            };
        }

        @Override
        default public E getAverage(Collection<E> modules) {
            return (E)((AverageableModule)modules.iterator().next());
        }
    }
}

