/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.modules.helpers;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.ModuleHelper;

@ModuleHelper
public interface FileBackedModule
extends ArchivableModule {
    public static final int DEFAULT_BUFFER_SIZE = 262144;

    public String getFileName();

    @Override
    default public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
        this.writeToArchive(output, entryPrefix, this.getFileName());
    }

    default public void writeToArchive(ArchiveOutput output, String entryPrefix, String fileName) throws IOException {
        FileBackedModule.initEntry(output, entryPrefix, fileName);
        OutputStream out = output.getOutputStream();
        BufferedOutputStream bout = out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
        this.writeToStream(bout);
        bout.flush();
        output.closeEntry();
    }

    public static String initEntry(ArchiveOutput out, String entryPrefix, String fileName) throws IOException {
        String entryName = ArchivableModule.getEntryName(entryPrefix, fileName);
        Preconditions.checkNotNull((Object)entryName, (String)"entryName is null. prefix='%s', fileName='%s'", (Object)entryPrefix, (Object)fileName);
        out.putNextEntry(entryName);
        return entryName;
    }

    public static OutputStream initOutputStream(ArchiveOutput out, String entryPrefix, String fileName) throws IOException {
        FileBackedModule.initEntry(out, entryPrefix, fileName);
        return out.getOutputStream();
    }

    public void writeToStream(OutputStream var1) throws IOException;

    @Override
    default public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
        BufferedInputStream zin = FileBackedModule.getInputStream(input, entryPrefix, this.getFileName());
        this.initFromStream(zin);
        zin.close();
    }

    public static boolean hasEntry(ArchiveInput input, String entryPrefix, String fileName) throws IOException {
        String entryName = ArchivableModule.getEntryName(entryPrefix, fileName);
        Preconditions.checkNotNull((Object)entryName, (String)"entryName is null. prefix='%s', fileName='%s'", (Object)entryPrefix, (Object)fileName);
        return input.hasEntry(entryName);
    }

    public static BufferedInputStream getInputStream(ArchiveInput input, String entryPrefix, String fileName) throws IOException {
        String entryName = ArchivableModule.getEntryName(entryPrefix, fileName);
        Preconditions.checkNotNull((Object)entryName, (String)"entryName is null. prefix='%s', fileName='%s'", (Object)entryPrefix, (Object)fileName);
        InputStream is = input.getInputStream(entryName);
        Preconditions.checkNotNull((Object)is, (String)"Couldn't load input stream for entryName='%s', prefix='%s', fileName='%s'", (Object)entryName, (Object)entryPrefix, (Object)fileName);
        return new BufferedInputStream(is, 262144);
    }

    public void initFromStream(BufferedInputStream var1) throws IOException;
}

