/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.calc;

import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.param.Parameter;
import org.opensha.nshmp2.erf.NSHMP2008;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.AbstractEpistemicListERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.EpistemicListERF;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2_TimeIndependentEpistemicList;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.utils.UpdatedUCERF2.MeanUCERF2update;
import scratch.UCERF3.utils.UpdatedUCERF2.MeanUCERF2update_FM2p1;
import scratch.UCERF3.utils.UpdatedUCERF2.ModMeanUCERF2update_FM2p1;
import scratch.UCERF3.utils.UpdatedUCERF2.U2GridSources;
import scratch.UCERF3.utils.UpdatedUCERF2.UCERF2_FM2pt1_FSS_ERFupdate;
import scratch.peter.ucerf3.calc.UC3_CalcUtils;

public enum ERF_ID {
    NSHMP08{

        @Override
        public EpistemicListERF instance() {
            return NSHMP2008.create();
        }
    }
    ,
    NSHMP08_CA{

        @Override
        public EpistemicListERF instance() {
            return NSHMP2008.createCalifornia();
        }
    }
    ,
    NSHMP08_CA_NW{

        @Override
        public EpistemicListERF instance() {
            return NSHMP2008.createCaliforniaNW();
        }
    }
    ,
    NSHMP08_CA_GRD{

        @Override
        public EpistemicListERF instance() {
            return NSHMP2008.createCaliforniaGridded();
        }
    }
    ,
    NSHMP08_CA_FLT{

        @Override
        public EpistemicListERF instance() {
            return NSHMP2008.createCaliforniaFault();
        }
    }
    ,
    NSHMP08_CA_FIX{

        @Override
        public EpistemicListERF instance() {
            return NSHMP2008.createCaliforniaFixedStrk();
        }
    }
    ,
    NSHMP08_CA_PT{

        @Override
        public EpistemicListERF instance() {
            return NSHMP2008.createCaliforniaPointSrc();
        }
    }
    ,
    MEAN_UCERF2{

        @Override
        public EpistemicListERF instance() {
            return ERF_ID.getMeanUC2();
        }
    }
    ,
    MEAN_UCERF2_GRD{

        @Override
        public EpistemicListERF instance() {
            return ERF_ID.getMeanUC2_GRD();
        }
    }
    ,
    MEAN_UCERF2_FIX{

        @Override
        public EpistemicListERF instance() {
            return ERF_ID.getMeanUC2_FIX();
        }
    }
    ,
    MEAN_UCERF2_PT{

        @Override
        public EpistemicListERF instance() {
            return ERF_ID.getMeanUC2_PT();
        }
    }
    ,
    MEAN_UCERF2_FM2P1{

        @Override
        public EpistemicListERF instance() {
            return ERF_ID.getMeanUC2_FM2P1();
        }
    }
    ,
    MOD_MEAN_UCERF2_FM2P1{

        @Override
        public EpistemicListERF instance() {
            return ERF_ID.getModMeanUC2_FM2P1();
        }
    }
    ,
    UCERF2_FM2P1_FSS_ERF{

        @Override
        public EpistemicListERF instance() {
            return ERF_ID.getUC2_FM2P1_FSS();
        }
    }
    ,
    UCERF2_TIME_INDEP{

        @Override
        public EpistemicListERF instance() {
            return ERF_ID.getUC2_TI();
        }
    }
    ,
    UCERF3_REF_MEAN{

        @Override
        public EpistemicListERF instance() {
            return ERF_ID.getUC3(ERF_ID.UC3_CONV_PATH);
        }
    }
    ,
    UCERF3_REF_MEAN_VAR0{

        @Override
        public EpistemicListERF instance() {
            return ERF_ID.getUC3(ERF_ID.UC3_CONV_PATH_VAR0);
        }
    }
    ,
    UCERF3_UC2MAP1{

        @Override
        public EpistemicListERF instance() {
            return ERF_ID.getUC3_noBG(ERF_ID.UC3_UC2_MAP_TAP);
        }
    }
    ,
    UCERF3_UC2MAP2{

        @Override
        public EpistemicListERF instance() {
            return ERF_ID.getUC3_noBG(ERF_ID.UC3_UC2_MAP_UNI);
        }
    }
    ,
    UCERF3_RATE_TEST{

        @Override
        public EpistemicListERF instance() {
            return ERF_ID.getUC3(ERF_ID.UC3_RATE_TEST);
        }
    }
    ,
    UCERF3_BRANCH{

        @Override
        public EpistemicListERF instance() {
            return null;
        }
    };

    private static final String BASE_PATH = "/home/scec-00/pmpowers/UC3/src";
    private static final String UC3_CONV_PATH = "/home/scec-00/pmpowers/UC3/src/conv/FM3_1_ZENG_Shaw09Mod_DsrTap_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_mean_sol.zip";
    private static final String UC3_CONV_PATH_VAR0 = "/home/scec-00/pmpowers/UC3/src/conv/FM3_1_ZENG_Shaw09Mod_DsrTap_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_VarZeros_mean_sol.zip";
    private static final String UC3_RATE_TEST = "/home/scec-00/pmpowers/UC3/src/rateTest/FM3_1_ZENG_Shaw09Mod_DsrTap_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_mean_sol.zip";
    private static final String UC31_PATH = "/home/scec-00/pmpowers/UC3/src/tree/2012_10_29-tree-fm31_x7-fm32_x1_COMPOUND_SOL.zip";
    private static final String UC32_PATH = "/home/scec-00/pmpowers/UC3/src/tree/2013_01_14-UC32-COMPOUND_SOL.zip";
    private static final String UC3_UC2_MAP_TAP = "/home/scec-00/pmpowers/UC3/src/uc2map/FM2_1_UC2ALL_AveU2_DsrTap_CharConst_M5Rate7.6_MMaxOff7.6_NoFix_SpatSeisU2_mean_sol.zip";
    private static final String UC3_UC2_MAP_UNI = "/home/scec-00/pmpowers/UC3/src/uc2map/FM2_1_UC2ALL_AveU2_DsrUni_CharConst_M5Rate7.6_MMaxOff7.6_NoFix_SpatSeisU2_mean_sol.zip";

    public abstract EpistemicListERF instance();

    private static EpistemicListERF getMeanUC2() {
        MeanUCERF2update erf = new MeanUCERF2update(U2GridSources.ALL);
        ERF_ID.setParams(erf);
        return ERF_ID.wrapInList(erf);
    }

    private static EpistemicListERF getMeanUC2_GRD() {
        MeanUCERF2update erf = new MeanUCERF2update(U2GridSources.ALL);
        ERF_ID.setParams(erf);
        erf.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_ONLY);
        return ERF_ID.wrapInList(erf);
    }

    private static EpistemicListERF getMeanUC2_FIX() {
        MeanUCERF2update erf = new MeanUCERF2update(U2GridSources.FIX_STRK);
        ERF_ID.setParams(erf);
        erf.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_ONLY);
        return ERF_ID.wrapInList(erf);
    }

    private static EpistemicListERF getMeanUC2_PT() {
        MeanUCERF2update erf = new MeanUCERF2update(U2GridSources.PT_SRC);
        ERF_ID.setParams(erf);
        erf.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_ONLY);
        return ERF_ID.wrapInList(erf);
    }

    private static EpistemicListERF getMeanUC2_FM2P1() {
        MeanUCERF2update_FM2p1 erf = new MeanUCERF2update_FM2p1();
        ERF_ID.setParams(erf);
        return ERF_ID.wrapInList(erf);
    }

    private static EpistemicListERF getModMeanUC2_FM2P1() {
        ModMeanUCERF2update_FM2p1 erf = new ModMeanUCERF2update_FM2p1();
        ERF_ID.setParams(erf);
        return ERF_ID.wrapInList(erf);
    }

    private static EpistemicListERF getUC2_FM2P1_FSS() {
        UCERF2_FM2pt1_FSS_ERFupdate erf = new UCERF2_FM2pt1_FSS_ERFupdate();
        erf.getTimeSpan().setDuration(1.0);
        return ERF_ID.wrapInList(erf);
    }

    private static EpistemicListERF getUC2_TI() {
        UCERF2_TimeIndependentEpistemicList erf = new UCERF2_TimeIndependentEpistemicList();
        Parameter bgSrcParam = erf.getParameter(UCERF2.BACK_SEIS_RUP_NAME);
        bgSrcParam.setValue(UCERF2.BACK_SEIS_RUP_POINT);
        Parameter floatParam = erf.getParameter("Floater Type");
        floatParam.setValue("Only along strike ( rupture full DDW)");
        TimeSpan ts = new TimeSpan("None", "Years");
        ts.setDuration(1.0);
        erf.setTimeSpan(ts);
        return erf;
    }

    private static EpistemicListERF getUC3(String solPath) {
        FaultSystemSolutionERF erf = UC3_CalcUtils.getUC3_ERF(solPath, IncludeBackgroundOption.INCLUDE, false, true, 1.0);
        return ERF_ID.wrapInList(erf);
    }

    private static EpistemicListERF getUC3_noBG(String solPath) {
        FaultSystemSolutionERF erf = UC3_CalcUtils.getUC3_ERF(solPath, IncludeBackgroundOption.EXCLUDE, false, true, 1.0);
        return ERF_ID.wrapInList(erf);
    }

    private static EpistemicListERF getUC3_onlyBG(String solPath) {
        FaultSystemSolutionERF erf = UC3_CalcUtils.getUC3_ERF(solPath, IncludeBackgroundOption.ONLY, false, true, 1.0);
        return ERF_ID.wrapInList(erf);
    }

    public static EpistemicListERF wrapInList(final AbstractERF erf) {
        AbstractEpistemicListERF listERF = new AbstractEpistemicListERF(){
            {
                this.addERF(erf, 1.0);
            }
        };
        listERF.setTimeSpan(erf.getTimeSpan());
        return listERF;
    }

    private static void setParams(ERF uc2) {
        uc2.setParameter("Rupture Offset", 1.0);
        uc2.setParameter("Probability Model", "Poisson");
        uc2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        uc2.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_POINT);
        uc2.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
        uc2.getTimeSpan().setDuration(1.0);
    }
}

