/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.calc;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.nshmp2.calc.HazardResult;
import org.opensha.nshmp2.calc.HazardResultWriter;
import org.opensha.nshmp2.util.Period;

public class HazardResultWriterSites
implements HazardResultWriter {
    private static final String N = System.getProperty("line.separator");
    private static final String S = File.separator;
    private static final Joiner JOIN = Joiner.on((char)',');
    private String outDir;
    private Map<String, Location> siteMap;

    public HazardResultWriterSites(String outDir, Map<String, Location> siteMap) throws IOException {
        this.outDir = outDir;
        this.siteMap = siteMap;
    }

    @Override
    public void write(HazardResult result) throws IOException {
        Period period = result.period();
        DiscretizedFunc f = result.curve();
        String siteName = this.siteNameForLoc(result.location());
        Iterable<String> cityData = HazardResultWriterSites.createResult(siteName, f);
        String cityLine = JOIN.join(cityData) + N;
        String outPath = this.outDir + S + String.valueOf((Object)period) + S + "curves.csv";
        File outFile = new File(outPath);
        Files.createParentDirs((File)outFile);
        Files.append((CharSequence)cityLine, (File)outFile, (Charset)Charsets.US_ASCII);
    }

    @Override
    public void close() {
    }

    private String siteNameForLoc(Location loc) {
        for (String name : this.siteMap.keySet()) {
            if (!LocationUtils.areSimilar(this.siteMap.get(name), loc)) continue;
            return name;
        }
        return "UnnamedSite";
    }

    private static Iterable<String> createResult(String name, DiscretizedFunc curve) {
        ArrayList intercepts = Lists.newArrayList((Object[])new String[]{name});
        Collection values = Collections2.transform(curve.yValues(), (Function)Functions.toStringFunction());
        return Iterables.concat((Iterable)intercepts, (Iterable)values);
    }

    public void writeHeader(Period period) throws IOException {
        String outPath = this.outDir + S + String.valueOf((Object)period) + S + "curves.csv";
        File outFile = new File(outPath);
        Files.createParentDirs((File)outFile);
        Collection xValsIt = Collections2.transform(period.getIMLs(), (Function)Functions.toStringFunction());
        String header = "city," + JOIN.join((Iterable)xValsIt) + N;
        Files.write((CharSequence)header, (File)outFile, (Charset)Charsets.US_ASCII);
    }
}

