/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensha.nshmp2.erf.source.CH_Data;
import org.opensha.nshmp2.erf.source.ClusterERF;
import org.opensha.nshmp2.erf.source.ClusterSource;
import org.opensha.nshmp2.erf.source.FaultParser;
import org.opensha.nshmp2.erf.source.FaultSource;
import org.opensha.nshmp2.erf.source.MagData;
import org.opensha.nshmp2.erf.source.SourceFile;
import org.opensha.nshmp2.erf.source.SourceMgr;
import org.opensha.nshmp2.util.FaultType;
import org.opensha.nshmp2.util.NSHMP_Utils;
import org.opensha.nshmp2.util.SourceIMR;
import org.opensha.nshmp2.util.SourceRegion;
import org.opensha.nshmp2.util.SourceType;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.FocalMech;

public class ClusterParser {
    private Logger log;

    ClusterParser(Logger log) {
        this.log = log;
    }

    ClusterERF parse(SourceFile sf) {
        String name = sf.getName();
        SourceRegion srcRegion = sf.getRegion();
        SourceType srcType = sf.getType();
        SourceIMR srcIMR = SourceIMR.imrForSource(srcType, srcRegion, name, null);
        double srcWt = sf.getWeight();
        List<String> dat = sf.readLines();
        Iterator<String> srcLines = dat.iterator();
        FaultParser.skipHeader1(srcLines);
        double rMax = NSHMP_Utils.readDouble(srcLines.next(), 1);
        FaultParser.skipHeader2(srcLines);
        MagData md = new MagData(NSHMP_Utils.readLines(srcLines, 4));
        md.toLog(this.log);
        HashMap srcMap = Maps.newHashMap();
        while (srcLines.hasNext()) {
            String[] fltDat = StringUtils.split((String)srcLines.next());
            int groupNum = NSHMP_Utils.readInt(fltDat, 3);
            int sectionNum = NSHMP_Utils.readInt(fltDat, 4);
            ClusterSource cs = (ClusterSource)srcMap.get(groupNum);
            if (cs == null) {
                cs = new ClusterSource();
                cs.name = "NMSZ Cluster: " + ClusterParser.createGroupName(groupNum);
                cs.file = sf;
                cs.rate = ClusterParser.readReturnPeriod(sf.getName());
                cs.weight = SourceMgr.getClusterWeight(sf.getName(), groupNum);
                srcMap.put(groupNum, cs);
            }
            FaultSource fs = new FaultSource();
            fs.name = ClusterParser.createSegmentName(groupNum, sectionNum);
            fs.file = sf;
            fs.type = FaultType.typeForID(NSHMP_Utils.readInt(fltDat, 0));
            fs.mech = FocalMech.typeForID(NSHMP_Utils.readInt(fltDat, 1));
            fs.nMag = NSHMP_Utils.readInt(fltDat, 2);
            fs.mfds = Lists.newArrayList();
            List<String> mfdSrcDat = NSHMP_Utils.readLines(srcLines, fs.nMag);
            this.generateMFDs(fs, mfdSrcDat);
            FaultParser.generateFaultTrace(srcLines, fs, this.log);
            FaultParser.toLog(this.log, fs);
            cs.sources.add(fs);
        }
        ImmutableList sources = ImmutableList.copyOf(srcMap.values());
        for (ClusterSource cs : sources) {
            ClusterParser.toLog(this.log, cs);
        }
        return new ClusterERF(name, (List<ClusterSource>)sources, srcRegion, srcIMR, srcWt, rMax);
    }

    private void generateMFDs(FaultSource fs, List<String> lines) {
        fs.floats = false;
        for (String line : lines) {
            CH_Data ch = new CH_Data(line);
            IncrementalMagFreqDist mfd = new IncrementalMagFreqDist(ch.mag, ch.mag, 1);
            mfd.set(ch.mag, ch.weight * ch.rate);
            fs.mfds.add(mfd);
            if (!this.log.isLoggable(Level.FINE)) continue;
            this.log.fine(IOUtils.LINE_SEPARATOR + "CH MFD: " + fs.name + IOUtils.LINE_SEPARATOR + mfd.getMetadataString());
        }
    }

    private static String createSegmentName(int grp, int sec) {
        StringBuffer sb = new StringBuffer("NMSZ (");
        sb.append(ClusterParser.createGroupName(grp)).append(", ");
        String secName = sec == 1 ? "north" : (sec == 2 ? "center" : (sec == 3 ? "south" : "unknown"));
        sb.append(secName).append(" section)");
        return sb.toString();
    }

    private static String createGroupName(int grp) {
        return (grp == 1 ? "west" : (grp == 2 ? "mid-west" : (grp == 3 ? "center" : (grp == 4 ? "mid-east" : (grp == 5 ? "east" : "unknown"))))) + " model";
    }

    private static double readReturnPeriod(String fname) {
        String[] parts = StringUtils.split((String)fname, (char)'.');
        return Double.valueOf(parts[1]);
    }

    private static void toLog(Logger log, ClusterSource cs) {
        if (log.isLoggable(Level.INFO)) {
            log.info(IOUtils.LINE_SEPARATOR + cs.toString());
        }
    }

    public static void main(String[] args) {
        Logger log = NSHMP_Utils.logger();
        Level level = Level.FINE;
        log.setLevel(level);
        for (Handler h : NSHMP_Utils.logger().getHandlers()) {
            h.setLevel(level);
        }
        log.info(String.valueOf(new Date()) + " " + ClusterParser.class.getName());
        ClusterParser dev = new ClusterParser(log);
        SourceFile sf = SourceMgr.get(SourceRegion.CEUS, SourceType.CLUSTER, "newmad.750.cluster.in").get(0);
        log.info("Source: " + sf.getName());
        ClusterERF erf = dev.parse(sf);
    }
}

