/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.opensha.nshmp2.erf.source.FaultParser;
import org.opensha.nshmp2.erf.source.FaultSource;
import org.opensha.nshmp2.erf.source.MagData;
import org.opensha.nshmp2.util.NSHMP_Utils;
import org.opensha.nshmp2.util.SourceType;

class GR_Data {
    double aVal;
    double bVal;
    double mMin;
    double mMax;
    double dMag;
    double weight;
    int nMag;

    GR_Data(String src, FaultSource fs, Logger log) {
        this.readSource(src);
        this.validateDeltaMag(log, fs);
        this.recenterMagBins(log, fs);
        this.validateMagCount(log, fs);
    }

    GR_Data(String src, SourceType type) {
        if (type == SourceType.GRIDDED) {
            double[] grDat = NSHMP_Utils.readDoubles(src, 4);
            this.bVal = grDat[0];
            this.mMin = grDat[1];
            this.mMax = grDat[2];
            this.dMag = grDat[3];
        } else if (type == SourceType.SUBDUCTION) {
            this.readSource(src);
            this.updateMagCount();
        }
    }

    GR_Data(double aVal, double bVal, double mMin, double mMax, double dMag) {
        this.aVal = aVal;
        this.bVal = bVal;
        this.mMin = mMin;
        this.mMax = mMax;
        this.dMag = dMag;
        this.recenterMagBins();
        this.updateMagCount();
    }

    private void readSource(String src) {
        String[] grDat = StringUtils.split((String)src);
        this.aVal = NSHMP_Utils.readDouble(grDat, 0);
        this.bVal = NSHMP_Utils.readDouble(grDat, 1);
        this.mMin = NSHMP_Utils.readDouble(grDat, 2);
        this.mMax = NSHMP_Utils.readDouble(grDat, 3);
        this.dMag = NSHMP_Utils.readDouble(grDat, 4);
        try {
            this.weight = NSHMP_Utils.readDouble(grDat, 5);
        }
        catch (ArrayIndexOutOfBoundsException oobe) {
            this.weight = 1.0;
        }
        this.nMag = 0;
    }

    private void validateDeltaMag(Logger log, FaultSource fs) {
        if (this.dMag <= 0.004) {
            StringBuilder sb = new StringBuilder().append("GR dMag [").append(this.dMag).append("] is being increased to 0.1");
            FaultParser.appendFaultDat(sb, fs);
            log.warning(sb.toString());
            this.dMag = 0.1;
        }
    }

    private void recenterMagBins(Logger log, FaultSource fs) {
        if (this.mMin == this.mMax) {
            StringBuilder sb = new StringBuilder().append("GR mMin and mMax are the same [").append(this.mMin).append("]; switching to CH");
            FaultParser.appendFaultDat(sb, fs);
            log.warning(sb.toString());
        } else {
            this.mMin += this.dMag / 2.0;
            this.mMax = this.mMax - this.dMag / 2.0 + 1.0E-4;
        }
    }

    private void recenterMagBins() {
        if (this.mMin == this.mMax) {
            return;
        }
        this.mMin += this.dMag / 2.0;
        this.mMax -= this.dMag / 2.0;
    }

    private void validateMagCount(Logger log, FaultSource fs) {
        this.updateMagCount();
        if (this.nMag < 1) {
            RuntimeException rex = new RuntimeException("Number of mags must be \u2265 1");
            StringBuilder sb = new StringBuilder().append("GR nMag is less than 1");
            FaultParser.appendFaultDat(sb, fs);
            log.log(Level.WARNING, sb.toString(), rex);
            throw rex;
        }
    }

    boolean hasMagExceptions(Logger log, FaultSource fs, MagData md) {
        if (this.nMag > 1) {
            double mMaxAdj = this.mMax + md.epiDeltas[0];
            if (mMaxAdj < 6.5) {
                StringBuilder sb = new StringBuilder().append("Multi mag GR mMax [").append(this.mMax).append("] with epistemic unc. [").append(mMaxAdj).append("] is < 6.5");
                FaultParser.appendFaultDat(sb, fs);
                log.warning(sb.toString());
                return true;
            }
        } else if (this.nMag == 1) {
            double mMaxAdj = md.aleaMinMag(this.mMax + md.epiDeltas[0]);
            if (md.hasAleatory && mMaxAdj < 6.5) {
                System.out.println("PP " + md.hasAleatory + " " + (mMaxAdj < 6.5) + " " + fs.name);
                System.exit(0);
            }
            if (mMaxAdj < 6.5) {
                StringBuilder sb = new StringBuilder().append("Single mag GR mMax [").append(this.mMax).append("] with epistemic and aleatory unc. [").append(mMaxAdj).append("] is < 6.5");
                FaultParser.appendFaultDat(sb, fs);
                log.warning(sb.toString());
                return true;
            }
        } else {
            StringBuilder sb = new StringBuilder().append("GR MFD with no mags");
            FaultParser.appendFaultDat(sb, fs);
            log.warning(sb.toString());
        }
        return false;
    }

    void updateMagCount() {
        this.nMag = (int)((this.mMax - this.mMin) / this.dMag + 1.4);
    }
}

