/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.RegionUtils;
import org.opensha.nshmp2.erf.source.FixedStrikeSource;
import org.opensha.nshmp2.erf.source.NSHMP_ERF;
import org.opensha.nshmp2.erf.source.Sources;
import org.opensha.nshmp2.util.FaultCode;
import org.opensha.nshmp2.util.NSHMP_Utils;
import org.opensha.nshmp2.util.SourceIMR;
import org.opensha.nshmp2.util.SourceRegion;
import org.opensha.nshmp2.util.SourceType;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.PointSourceNshm;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrection;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrections;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.FocalMech;

public class GridERF
extends NSHMP_ERF {
    private String name;
    private String info;
    private LocationList locs;
    private Region border;
    private Region bounds;
    private List<IncrementalMagFreqDist> mfds;
    private int[] srcIndices;
    private Map<FocalMech, Double> mechWtMap;
    private double[] depths;
    private FaultCode faultCode;
    private double strike;
    private SourceRegion srcRegion;
    private SourceIMR srcIMR;
    private double weight;
    private double maxR;
    private double dR;
    private static WeightedList<PointSourceDistanceCorrection> distCorrs = PointSourceDistanceCorrections.NSHM_2008.get();
    private static final MagLengthRelationship MLR = new WC1994_MagLengthRelationship();

    GridERF(String name, String info, Region border, LocationList locs, List<IncrementalMagFreqDist> mfds, double[] depths, Map<FocalMech, Double> mechWtMap, FaultCode faultCode, double strike, SourceRegion srcRegion, SourceIMR srcIMR, double weight, double maxR, double dR) {
        this.name = name;
        this.info = info;
        this.border = border;
        this.locs = locs;
        this.mfds = mfds;
        this.depths = depths;
        this.mechWtMap = mechWtMap;
        this.faultCode = faultCode;
        this.strike = strike;
        this.srcRegion = srcRegion;
        this.srcIMR = srcIMR;
        this.weight = weight;
        this.maxR = maxR;
        this.dR = dR;
        this.initIndices();
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.setDuration(1.0);
        this.timeSpan.addParameterChangeListener(this);
    }

    private void initIndices() {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.mfds.size(); ++i) {
            if (this.mfds.get(i) == null) continue;
            list.add(i);
        }
        this.srcIndices = Ints.toArray((Collection)list);
    }

    private void initBounds() {
        this.bounds = NSHMP_Utils.createBounds(this.border.getBorder(), this.maxR + 10.0);
    }

    public LocationList getNodes() {
        return this.locs;
    }

    public Region getBorder() {
        return this.border;
    }

    @Override
    public int getNumSources() {
        return this.srcIndices.length;
    }

    @Override
    public int getRuptureCount() {
        int count = 0;
        for (IncrementalMagFreqDist mfd : this.mfds) {
            count += mfd.size();
        }
        return count;
    }

    @Override
    public SourceRegion getSourceRegion() {
        return this.srcRegion;
    }

    @Override
    public SourceType getSourceType() {
        return SourceType.GRIDDED;
    }

    @Override
    public SourceIMR getSourceIMR() {
        return this.srcIMR;
    }

    @Override
    public double getSourceWeight() {
        return this.weight;
    }

    @Override
    public double getMaxDistance() {
        return this.maxR;
    }

    @Override
    public Region getBounds() {
        return this.bounds;
    }

    public FaultCode getFaultCode() {
        return this.faultCode;
    }

    public double getDistanceInterval() {
        return this.dR;
    }

    public double[] getDepths() {
        return this.depths;
    }

    public Map<FocalMech, Double> getFocalMechs() {
        return this.mechWtMap;
    }

    @Override
    public List<ProbEqkSource> getSourceList() {
        throw new UnsupportedOperationException("A GridSource does not allow access to the list of all possible sources.");
    }

    @Override
    public Iterator<ProbEqkSource> iterator() {
        return new Iterator<ProbEqkSource>(){
            int size;
            int caret;
            {
                this.size = GridERF.this.getNumSources();
                this.caret = 0;
            }

            @Override
            public boolean hasNext() {
                return this.caret < this.size;
            }

            @Override
            public ProbEqkSource next() {
                return GridERF.this.getSource(this.caret++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ProbEqkSource getSource(int idx) {
        idx = this.srcIndices[idx];
        return this.faultCode == FaultCode.FIXED ? new FixedStrikeSource((Location)this.locs.get(idx), this.mfds.get(idx), MLR, this.timeSpan.getDuration(), this.depths, this.mechWtMap, this.strike) : new PointSourceNshm((Location)this.locs.get(idx), this.mfds.get(idx), this.timeSpan.getDuration(), this.mechWtMap, 6.5, this.depths[0], this.depths[1], distCorrs);
    }

    public IncrementalMagFreqDist getMFD(Location loc) {
        for (int i = 0; i < this.locs.size(); ++i) {
            if (!LocationUtils.areSimilar((Location)this.locs.get(i), loc)) continue;
            return this.mfds.get(i);
        }
        return null;
    }

    @Override
    public void updateForecast() {
        this.initBounds();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.info;
    }

    public void scaleRatesToWeight() {
        double wt = this.getSourceWeight();
        for (int idx : this.srcIndices) {
            this.mfds.get(idx).scale(wt);
        }
    }

    public static void main(String[] args) {
        GridERF tmpERF = Sources.getGrid("CEUS.2007all8.AB.in");
        RegionUtils.regionToKML(tmpERF.getBorder(), "CEUSborder", Color.RED);
        RegionUtils.regionToKML(tmpERF.getBounds(), "CEUSbounds", Color.ORANGE);
        tmpERF = Sources.getGrid("pnwdeep.in");
        RegionUtils.regionToKML(tmpERF.getBorder(), "PNWdeepBorder", Color.RED);
        RegionUtils.regionToKML(tmpERF.getBounds(), "PNWdeepBounds", Color.ORANGE);
    }

    public static GridERF getTestGrid(Location loc, GridERF erf) {
        Logger log = NSHMP_Utils.logger();
        Level level = Level.FINE;
        log.setLevel(level);
        for (Handler h : NSHMP_Utils.logger().getHandlers()) {
            h.setLevel(level);
        }
        IncrementalMagFreqDist mfd = erf.getMFD(loc);
        erf.mfds.clear();
        erf.mfds.add(mfd);
        erf.locs.clear();
        erf.locs.add(loc);
        erf.name = "Small Test GridERF";
        erf.initIndices();
        return erf;
    }
}

