/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensha.nshmp2.util.NSHMP_Utils;

class MagData
implements Cloneable {
    int numEpiBranches;
    double[] epiDeltas;
    double[] epiWeights;
    double aleaSigma;
    int aleaMagCt;
    boolean hasEpistemic;
    boolean hasAleatory;
    boolean momentBalance;

    MagData() {
        this.epiDeltas = new double[]{0.0};
        this.epiWeights = new double[]{0.0};
    }

    MagData(List<String> src) {
        this.numEpiBranches = NSHMP_Utils.readInt(src.get(0), 0);
        this.epiDeltas = NSHMP_Utils.readDoubles(src.get(1), this.numEpiBranches);
        this.epiWeights = NSHMP_Utils.readDoubles(src.get(2), this.numEpiBranches);
        this.hasEpistemic = this.numEpiBranches > 1;
        String[] aleatoryMagDat = StringUtils.split((String)src.get(3));
        double aleatorySigmaTmp = NSHMP_Utils.readDouble(aleatoryMagDat, 0);
        this.momentBalance = aleatorySigmaTmp > 0.0;
        this.aleaSigma = Math.abs(aleatorySigmaTmp);
        this.aleaMagCt = NSHMP_Utils.readInt(aleatoryMagDat, 1) * 2 + 1;
        this.hasAleatory = this.aleaMagCt > 1 && this.aleaSigma != 0.0;
    }

    double aleaMinMag(double mag) {
        return mag - 2.0 * this.aleaSigma;
    }

    double aleaMaxMag(double mag) {
        return mag + 2.0 * this.aleaSigma;
    }

    void suppressUncertainty() {
        this.hasEpistemic = false;
        this.hasAleatory = false;
    }

    public MagData clone() {
        try {
            MagData clone = (MagData)super.clone();
            clone.epiDeltas = ArrayUtils.clone((double[])this.epiDeltas);
            clone.epiWeights = ArrayUtils.clone((double[])this.epiWeights);
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    void toLog(Logger log) {
        if (log.isLoggable(Level.INFO)) {
            log.info(IOUtils.LINE_SEPARATOR + this.toString());
        }
    }

    public String toString() {
        return "============= MFD Data =============" + IOUtils.LINE_SEPARATOR + "Epistemic unc: " + this.hasEpistemic + IOUtils.LINE_SEPARATOR + "     M deltas: " + Arrays.toString(this.epiDeltas) + IOUtils.LINE_SEPARATOR + "    M weights: " + Arrays.toString(this.epiWeights) + IOUtils.LINE_SEPARATOR + " Aleatory unc: " + this.hasAleatory + IOUtils.LINE_SEPARATOR + "      M sigma: " + this.aleaSigma + IOUtils.LINE_SEPARATOR + "      M count: " + this.aleaMagCt + IOUtils.LINE_SEPARATOR + "   Mo balance: " + this.momentBalance + IOUtils.LINE_SEPARATOR;
    }
}

