/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.nshmp2.util.NSHMP_Utils;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.FocalMech;
import org.opensha.sha.util.NSHMP_Util;

public class PointSource13
extends ProbEqkSource {
    private static final String NAME = "NSHMP Point Source";
    private static final double M_DEPTH_CUT = 6.5;
    public static final double M_FINITE_CUT = 6.0;
    private static final MagLengthRelationship WC94 = new WC1994_MagLengthRelationship();
    private Location loc;
    private IncrementalMagFreqDist mfd;
    private double duration;
    private double lgMagDepth;
    private double smMagDepth;
    private Map<FocalMech, Double> mechWts;
    private int mechCount;
    private int ssIdx;
    private int revIdx;
    private int fwIdxLo;
    private int fwIdxHi;
    private PointSurface13 surface;
    protected ProbEqkRupture probEqkRupture;

    public PointSource13(Location loc, IncrementalMagFreqDist mfd, double duration, double[] depths, Map<FocalMech, Double> mechWtMap) {
        this.name = NAME;
        this.loc = loc;
        this.mfd = mfd;
        this.duration = duration;
        this.smMagDepth = depths[0];
        this.lgMagDepth = depths[1];
        this.mechWts = mechWtMap;
        this.mechCount = PointSource13.countMechs(mechWtMap);
        this.setIndices();
        this.probEqkRupture = new ProbEqkRupture();
        this.surface = new PointSurface13(loc);
    }

    @Override
    public ProbEqkRupture getRupture(int idx) {
        FocalMech mech = this.mechForIndex(idx);
        double wt = this.mechWts.get((Object)mech);
        if (mech != FocalMech.STRIKE_SLIP) {
            wt *= 0.5;
        }
        int magIdx = idx % this.mfd.size();
        double mag = this.mfd.getX(magIdx);
        double depth = this.depthForMag(mag);
        boolean footwall = this.isOnFootwall(idx);
        double width = this.calcWidth(mag, depth, mech.dip());
        this.updateRupture(mag, mech.dip(), mech.rake(), depth, width, footwall);
        double rate = wt * this.mfd.getY(magIdx);
        this.probEqkRupture.setProbability(NSHMP_Utils.rateToProb(rate, this.duration));
        return this.probEqkRupture;
    }

    @Override
    public List<ProbEqkRupture> getRuptureList() {
        throw new UnsupportedOperationException("A PointSource does not allow access to the list of all possible ruptures.");
    }

    @Override
    public Iterator<ProbEqkRupture> iterator() {
        return new Iterator<ProbEqkRupture>(){
            int size;
            int caret;
            {
                this.size = PointSource13.this.getNumRuptures();
                this.caret = 0;
            }

            @Override
            public boolean hasNext() {
                return this.caret < this.size;
            }

            @Override
            public ProbEqkRupture next() {
                return PointSource13.this.getRupture(this.caret++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void updateRupture(double mag, double dip, double rake, double depth, double width, boolean footwall) {
        this.probEqkRupture.setMag(mag);
        this.probEqkRupture.setAveRake(rake);
        this.surface.setAveDip(dip);
        if (this.surface.getDepth() != depth) {
            this.surface.setDepth(depth);
        }
        this.surface.width = width;
        this.surface.footwall = footwall;
        this.probEqkRupture.setPointSurface(this.surface);
    }

    @Override
    public LocationList getAllSourceLocs() {
        LocationList locList = new LocationList();
        locList.add(this.surface.getLocation());
        return locList;
    }

    @Override
    public RuptureSurface getSourceSurface() {
        return this.surface;
    }

    @Override
    public int getNumRuptures() {
        return this.mfd.size() * this.mechCount;
    }

    @Override
    public double getMinDistance(Site site) {
        return LocationUtils.horzDistanceFast(site.getLocation(), this.loc);
    }

    public Location getLocation() {
        return this.loc;
    }

    private double calcWidth(double mag, double depth, double dip) {
        double length = WC94.getMedianLength(mag);
        double aspectWidth = length / 1.5;
        double ddWidth = (14.0 - depth) / Math.sin(dip * GeoTools.TO_RAD);
        return Math.min(aspectWidth, ddWidth);
    }

    private FocalMech mechForIndex(int idx) {
        return idx < this.ssIdx ? FocalMech.STRIKE_SLIP : (idx < this.revIdx ? FocalMech.REVERSE : FocalMech.NORMAL);
    }

    private boolean isOnFootwall(int idx) {
        return idx < this.fwIdxLo ? true : (idx < this.revIdx ? false : idx < this.fwIdxHi);
    }

    private double depthForMag(double mag) {
        return mag >= 6.5 ? this.lgMagDepth : this.smMagDepth;
    }

    private static int countMechs(Map<FocalMech, Double> map) {
        int count = 0;
        for (FocalMech mech : map.keySet()) {
            double wt = map.get((Object)mech);
            if (wt == 0.0) continue;
            count += mech == FocalMech.STRIKE_SLIP ? 1 : 2;
        }
        return count;
    }

    private void setIndices() {
        int nMag = this.mfd.size();
        int ssCount = (int)Math.ceil(this.mechWts.get((Object)FocalMech.STRIKE_SLIP)) * nMag;
        int revCount = (int)Math.ceil(this.mechWts.get((Object)FocalMech.REVERSE)) * nMag * 2;
        int norCount = (int)Math.ceil(this.mechWts.get((Object)FocalMech.NORMAL)) * nMag * 2;
        this.ssIdx = ssCount;
        this.revIdx = ssCount + revCount;
        this.fwIdxLo = ssCount + revCount / 2;
        this.fwIdxHi = ssCount + revCount + norCount / 2;
    }

    public static void main(String[] args) {
        double dist = 6.5;
        double xmag = 6.05;
        double dr_rjb = 1.0;
        double dm_rjb = 0.1;
        double xmmin_rjb = 6.05;
        int irjb = (int)(dist / dr_rjb + 1.0);
        int m_ind = 1 + Math.max(0, (int)Math.rint((xmag - xmmin_rjb) / dm_rjb));
        m_ind = Math.min(26, m_ind);
        System.out.println("m_ind: " + m_ind);
        System.out.println("irjb: " + irjb);
        System.out.println("====");
        double mCorr = (double)Math.round(xmag / 0.05) * 0.05;
        double r = NSHMP_Util.getMeanRJB(mCorr, dist);
        System.out.println(r);
    }

    private static class PointSurface13
    extends PointSurface {
        private double width;
        private boolean footwall;

        public PointSurface13(Location loc) {
            super(loc);
        }

        @Override
        public double getAveWidth() {
            return this.width;
        }

        @Override
        public double getDistanceX(Location siteLoc) {
            double rJB = this.getDistanceJB(siteLoc);
            return this.footwall ? -rJB : rJB;
        }
    }
}

