/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import com.google.common.base.Predicate;
import org.opensha.nshmp2.erf.source.FaultSource;
import org.opensha.nshmp2.util.FaultType;
import org.opensha.sha.util.FocalMech;

public class SourcePredicates {
    public static Predicate<FaultSource> name(String name) {
        return new SourceName(name);
    }

    public static Predicate<FaultSource> dip(double dip) {
        return new SourceDip(dip);
    }

    public static Predicate<FaultSource> type(FaultType type) {
        return new SourceType(type);
    }

    public static Predicate<FaultSource> mech(FocalMech mech) {
        return new SourceMech(mech);
    }

    public static Predicate<FaultSource> floats(boolean floats) {
        return new SourceFloats(floats);
    }

    private static class SourceName
    implements Predicate<FaultSource> {
        String name;

        SourceName(String name) {
            this.name = name;
        }

        public boolean apply(FaultSource input) {
            return input.name.equals(this.name);
        }

        public String toString() {
            return "Name: " + this.name;
        }
    }

    private static class SourceDip
    implements Predicate<FaultSource> {
        double dip;

        SourceDip(double dip) {
            this.dip = dip;
        }

        public boolean apply(FaultSource input) {
            return input.dip == this.dip;
        }

        public String toString() {
            return "Dip: " + this.dip;
        }
    }

    private static class SourceType
    implements Predicate<FaultSource> {
        FaultType type;

        SourceType(FaultType type) {
            this.type = type;
        }

        public boolean apply(FaultSource input) {
            return input.type.equals((Object)this.type);
        }

        public String toString() {
            return "FaultType: " + String.valueOf((Object)this.type);
        }
    }

    private static class SourceMech
    implements Predicate<FaultSource> {
        FocalMech mech;

        SourceMech(FocalMech mech) {
            this.mech = mech;
        }

        public boolean apply(FaultSource input) {
            return input.mech.equals((Object)this.mech);
        }

        public String toString() {
            return "FocalMech: " + String.valueOf((Object)this.mech);
        }
    }

    private static class SourceFloats
    implements Predicate<FaultSource> {
        boolean floats;

        SourceFloats(boolean floats) {
            this.floats = floats;
        }

        public boolean apply(FaultSource input) {
            return input.floats == this.floats;
        }

        public String toString() {
            return "Floats: " + this.floats;
        }
    }
}

