/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import com.google.common.collect.Lists;
import java.util.List;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.nshmp2.erf.source.FaultSource;
import org.opensha.nshmp2.erf.source.NSHMP_ERF;
import org.opensha.nshmp2.erf.source.SubductionSource;
import org.opensha.nshmp2.util.NSHMP_Utils;
import org.opensha.nshmp2.util.SourceIMR;
import org.opensha.nshmp2.util.SourceRegion;
import org.opensha.nshmp2.util.SourceType;
import org.opensha.sha.earthquake.ProbEqkSource;

public class SubductionERF
extends NSHMP_ERF {
    private String name;
    private List<SubductionSource> sources;
    private List<ProbEqkSource> sourcesAsEqs;
    private SourceRegion srcRegion;
    private SourceIMR srcIMR;
    private double weight;
    private double maxR;
    private Region bounds;

    SubductionERF(String name, List<SubductionSource> sources, SourceRegion srcRegion, SourceIMR srcIMR, double weight, double maxR) {
        this.name = name;
        this.sources = sources;
        this.srcRegion = srcRegion;
        this.srcIMR = srcIMR;
        this.weight = weight;
        this.maxR = maxR;
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.setDuration(1.0);
        this.timeSpan.addParameterChangeListener(this);
    }

    @Override
    public int getNumSources() {
        return this.sources.size();
    }

    @Override
    public List<ProbEqkSource> getSourceList() {
        if (this.sourcesAsEqs == null) {
            this.sourcesAsEqs = Lists.newArrayList();
            for (ProbEqkSource probEqkSource : this.sources) {
                this.sourcesAsEqs.add(probEqkSource);
            }
        }
        return this.sourcesAsEqs;
    }

    public List<SubductionSource> getSources() {
        return this.sources;
    }

    @Override
    public ProbEqkSource getSource(int idx) {
        return this.sources.get(idx);
    }

    @Override
    public void updateForecast() {
        int count = 0;
        for (FaultSource faultSource : this.sources) {
            faultSource.init();
            count += faultSource.getNumRuptures();
        }
        this.initBounds();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRuptureCount() {
        int count = 0;
        for (FaultSource faultSource : this.sources) {
            count += faultSource.getNumRuptures();
        }
        return count;
    }

    @Override
    public SourceRegion getSourceRegion() {
        return this.srcRegion;
    }

    @Override
    public SourceType getSourceType() {
        return SourceType.SUBDUCTION;
    }

    @Override
    public SourceIMR getSourceIMR() {
        return this.srcIMR;
    }

    @Override
    public double getSourceWeight() {
        return this.weight;
    }

    @Override
    public double getMaxDistance() {
        return this.maxR;
    }

    @Override
    public Region getBounds() {
        return this.bounds;
    }

    private void initBounds() {
        double minLat = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        double minLon = Double.POSITIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        for (FaultSource faultSource : this.sources) {
            LocationList locs = faultSource.getAllSourceLocs();
            minLat = Math.min(minLat, LocationUtils.calcMinLat(locs));
            maxLat = Math.max(maxLat, LocationUtils.calcMaxLat(locs));
            minLon = Math.min(minLon, LocationUtils.calcMinLon(locs));
            maxLon = Math.max(maxLon, LocationUtils.calcMaxLon(locs));
        }
        this.bounds = NSHMP_Utils.creatBounds(minLat, maxLat, minLon, maxLon, this.maxR);
    }
}

