/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.nshmp2.util.Period;
import org.opensha.nshmp2.util.SiteType;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

public class NSHMP08_CEUS
extends AttenuationRelationship
implements ParameterChangeListener {
    public static final String NAME = "NSHMP 2008 CEUS Combined";
    public static final String SHORT_NAME = "NSHMP08_CEUS";
    private static final long serialVersionUID = 1L;
    private static final double VS30_WARN_MIN = 80.0;
    private static final double VS30_WARN_MAX = 1300.0;
    Map<ScalarIMR, Double> imrMap;
    private EnumParameter<SiteType> siteTypeParam;

    public NSHMP08_CEUS() {
        this.initImrMap();
        this.initSupportedIntensityMeasureParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initParameterEventListeners();
    }

    void initImrMap() {
        this.imrMap = Maps.newHashMap();
        this.imrMap.put(AttenRelRef.TORO_1997.instance(null), 0.2);
        this.imrMap.put(AttenRelRef.SOMERVILLE_2001.instance(null), 0.2);
        this.imrMap.put(AttenRelRef.FEA_1996.instance(null), 0.1);
        this.imrMap.put(AttenRelRef.AB_2006_140.instance(null), 0.1);
        this.imrMap.put(AttenRelRef.AB_2006_200.instance(null), 0.1);
        this.imrMap.put(AttenRelRef.CAMPBELL_2003.instance(null), 0.1);
        this.imrMap.put(AttenRelRef.TP_2005.instance(null), 0.1);
        this.imrMap.put(AttenRelRef.SILVA_2002.instance(null), 0.1);
    }

    @Override
    public void setUserMaxDistance(double maxDist) {
        for (ScalarIMR imr : this.imrMap.keySet()) {
            imr.setUserMaxDistance(maxDist);
        }
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.sigmaTruncTypeParam.setValueAsDefault();
        this.sigmaTruncLevelParam.setValueAsDefault();
        this.siteTypeParam.setValueAsDefault();
        this.tectonicRegionTypeParam.setValueAsDefault();
        for (ScalarIMR imr : this.imrMap.keySet()) {
            imr.setParamDefaults();
        }
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected void setPropagationEffectParams() {
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        ArrayList perVals = Lists.newArrayList();
        for (Period p : Period.getCEUS()) {
            perVals.add(p.getValue());
        }
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint(perVals);
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint, 1.0, false);
        this.saPeriodParam.addParameterChangeListener(this);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initSiteParams() {
        this.siteParams.clear();
        this.vs30Param = new Vs30_Param(80.0, 1300.0);
        this.siteParams.addParameter(this.vs30Param);
        this.siteTypeParam = new EnumParameter<SiteType>("Site Type", EnumSet.of(SiteType.FIRM_ROCK, SiteType.HARD_ROCK), SiteType.FIRM_ROCK, null);
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.AVE_HORZ, Component.AVE_HORZ);
        this.componentParam.setValueAsDefault();
        this.otherParams.addParameter(this.componentParam);
        this.sigmaTruncTypeParam.setValue("1 Sided");
        this.sigmaTruncLevelParam.setValue(3.0);
        this.sigmaTruncTypeParam.addParameterChangeListener(this);
        this.sigmaTruncLevelParam.addParameterChangeListener(this);
        for (ScalarIMR imr : this.imrMap.keySet()) {
            ParameterList parameterList = imr.getOtherParams();
        }
    }

    @Override
    protected void initEqkRuptureParams() {
    }

    @Override
    protected void initPropagationEffectParams() {
    }

    @Override
    protected void initParameterEventListeners() {
        this.vs30Param.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }

    @Override
    public void setSite(Site site) {
        this.site = site;
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        for (ScalarIMR imr : this.imrMap.keySet()) {
            imr.setSite(site);
        }
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        this.eqkRupture = eqkRupture;
        for (ScalarIMR imr : this.imrMap.keySet()) {
            imr.setEqkRupture(eqkRupture);
        }
    }

    @Override
    public double getMean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getStdDev() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getEpsilon() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getEpsilon(double iml) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) throws ParameterException {
        Utils.zeroFunc(imls);
        DiscretizedFunc f = imls.deepClone();
        for (ScalarIMR imr : this.imrMap.keySet()) {
            f = imr.getExceedProbabilities(f);
            f.scale(this.imrMap.get(imr));
            Utils.addFunc(imls, f);
        }
        return imls;
    }

    @Override
    public double getExceedProbability() throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected double getExceedProbability(double mean, double stdDev, double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getExceedProbability(double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getIML_AtExceedProb() throws ParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getIML_AtExceedProb(double exceedProb) throws ParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiscretizedFunc getSA_ExceedProbSpectrum(double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiscretizedFunc getSA_IML_AtExceedProbSpectrum(double exceedProb) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIntensityMeasureLevel(Double iml) throws ParameterException {
        for (ScalarIMR imr : this.imrMap.keySet()) {
            imr.setIntensityMeasureLevel(iml);
        }
    }

    @Override
    public void setIntensityMeasureLevel(Object iml) throws ParameterException {
        for (ScalarIMR imr : this.imrMap.keySet()) {
            imr.setIntensityMeasureLevel(iml);
        }
    }

    @Override
    public void setIntensityMeasure(String intensityMeasureName) throws ParameterException {
        super.setIntensityMeasure(intensityMeasureName);
        for (ScalarIMR imr : this.imrMap.keySet()) {
            imr.setIntensityMeasure(intensityMeasureName);
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        ParameterList pList;
        String pName = e.getParameterName();
        for (ScalarIMR imr : this.imrMap.keySet()) {
            ParameterChangeListener pcl = (ParameterChangeListener)((Object)imr);
            pcl.parameterChange(e);
        }
        if (this.otherParams.containsParameter(e.getParameter())) {
            for (ScalarIMR imr : this.imrMap.keySet()) {
                pList = imr.getOtherParams();
                if (!pList.containsParameter(pName)) continue;
                Parameter param = imr.getOtherParams().getParameter(e.getParameterName());
                if (param instanceof StringParameter) {
                    ((StringParameter)param).setValue((String)e.getParameter().getValue());
                    continue;
                }
                ((DoubleParameter)param).setValue((Double)e.getParameter().getValue());
            }
        }
        if (e.getParameterName().equals("SA Period")) {
            for (ScalarIMR imr : this.imrMap.keySet()) {
                pList = imr.getSupportedIntensityMeasures();
                SA_Param sap = (SA_Param)pList.getParameter("SA");
                sap.getPeriodParam().setValue((Double)this.saPeriodParam.getValue());
            }
        }
    }
}

