/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.nshmp2.imr.GridIMR;
import org.opensha.nshmp2.imr.NSHMP08_CEUS;
import org.opensha.nshmp2.util.CurveTable;
import org.opensha.nshmp2.util.FaultCode;
import org.opensha.nshmp2.util.Period;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.ScalarIMR;

public class NSHMP08_CEUS_Grid
extends NSHMP08_CEUS
implements GridIMR {
    public static final String NAME = "NSHMP 2008 CEUS Combined (Grid)";
    public static final String SHORT_NAME = "NSHMP08_CEUS_GRID";
    private static Map<FaultCode, Map<Period, CurveTable>> tables = Maps.newEnumMap(FaultCode.class);
    private CurveTable table;
    private FaultCode code;
    private double utilMag;
    private static final double R = 1000.0;
    private static final double dR = 5.0;
    private static final double minM = 5.0;
    private static final double maxM = 7.4;
    private static final double dM = 0.1;

    @Override
    void initImrMap() {
        this.imrMap = Maps.newHashMap();
        this.imrMap.put(AttenRelRef.TORO_1997.instance(null), 0.25);
        this.imrMap.put(AttenRelRef.FEA_1996.instance(null), 0.125);
        this.imrMap.put(AttenRelRef.AB_2006_140.instance(null), 0.125);
        this.imrMap.put(AttenRelRef.AB_2006_200.instance(null), 0.125);
        this.imrMap.put(AttenRelRef.CAMPBELL_2003.instance(null), 0.125);
        this.imrMap.put(AttenRelRef.TP_2005.instance(null), 0.125);
        this.imrMap.put(AttenRelRef.SILVA_2002.instance(null), 0.125);
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void setTable(FaultCode code) {
        Preconditions.checkNotNull((Object)((Object)code));
        Preconditions.checkArgument((code == FaultCode.M_CONV_AB || code == FaultCode.M_CONV_J ? 1 : 0) != 0, (String)"Supplied code [%s] is not allowed", (Object)((Object)code));
        this.code = code;
        Period p = Period.valueForPeriod((Double)this.getParameter("SA Period").getValue());
        this.table = tables.get((Object)code).get((Object)p);
        if (this.table == null) {
            this.table = NSHMP08_CEUS_Grid.initTable(code, p, this.imrMap);
        }
    }

    private static synchronized CurveTable initTable(FaultCode code, Period period, Map<ScalarIMR, Double> imrMap) {
        CurveTable table = tables.get((Object)code).get((Object)period);
        if (table != null) {
            System.out.println("Cached CEUS table [" + String.valueOf((Object)code) + ", " + String.valueOf((Object)period) + "]");
            return table;
        }
        for (ScalarIMR imr : imrMap.keySet()) {
            imr.setIntensityMeasure(period == Period.GM0P00 ? "PGA" : "SA");
            imr.getParameter("SA Period").setValue(period.getValue());
        }
        System.out.println("Building CEUS table [" + String.valueOf((Object)code) + ", " + String.valueOf((Object)period) + "]");
        table = CurveTable.create(1000.0, 5.0, 5.0, 7.4, 0.1, imrMap, period.getFunction(), code);
        tables.get((Object)code).put(period, table);
        return table;
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        this.utilMag = eqkRupture.getMag();
        eqkRupture.setMag(Utils.mblgToMw(this.code, this.utilMag));
        super.setEqkRupture(eqkRupture);
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) throws ParameterException {
        double d = this.eqkRupture.getRuptureSurface().getDistanceJB(this.site.getLocation());
        return this.table.get(d, this.utilMag);
    }

    @Override
    public DiscretizedFunc getExceedProbFromParent(DiscretizedFunc imls) {
        throw new UnsupportedOperationException("This method not required by CEUS Grid IMR");
    }

    public static void main(String[] args) {
        NSHMP08_CEUS_Grid imr = new NSHMP08_CEUS_Grid();
        Period per = Period.GM0P00;
        FaultCode fc = FaultCode.M_CONV_AB;
        imr.setIntensityMeasure(per == Period.GM0P00 ? "PGA" : "SA");
        imr.getParameter("SA Period").setValue(per.getValue());
        imr.setTable(fc);
        System.out.println(tables.get((Object)fc).get((Object)per).get(12.0, 6.55));
        System.out.println(tables.get((Object)fc).get((Object)per).get(0.0, 5.0));
    }

    static {
        EnumMap AB_map = Maps.newEnumMap(Period.class);
        EnumMap J_map = Maps.newEnumMap(Period.class);
        tables.put(FaultCode.M_CONV_AB, AB_map);
        tables.put(FaultCode.M_CONV_J, J_map);
    }
}

