/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.nshmp2.util.Params;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupTopDepthParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.util.TectonicRegionType;

public class YoungsEtAl_1997_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    private static final String SHORT_NAME = "YoungsEtAl1997";
    public static final String NAME = "Youngs et al. (1997)";
    private static final long serialVersionUID = 1L;
    private static final double[] pd = new double[]{0.0, 0.2, 1.0, 0.1, 0.3, 0.5, 2.0, 0.4, 0.75, 1.5, 3.0, 4.0, 5.0};
    private static final double[] vgeo = new double[]{760.0, 300.0, 475.0};
    private static final double[] gc1 = new double[]{0.0, 0.722, -1.736, 1.188, 0.246, -0.4, -3.328, -0.115, -1.149, -2.634, -4.511, -5.35, -6.025};
    private static final double[] gc1s = new double[]{0.0, 1.549, -2.87, 2.516, 0.793, -0.438, -6.433, 0.144, -1.704, -5.101, -6.672, -7.618, -8.352};
    private static final double[] gc2 = new double[]{0.0, -0.0027, -0.0064, -0.0011, -0.0036, -0.0048, -0.008, -0.0042, -0.0057, -0.0073, -0.0089, -0.0096, -0.0101};
    private static final double[] gc2s = new double[]{0.0, -0.0019, -0.0066, -0.0019, -0.002, -0.0035, -0.0164, -0.002, -0.0048, -0.0114, -0.0221, -0.0235, -0.0246};
    private static final double[] gc3 = new double[]{-2.556, -2.528, -2.234, -2.655, -2.454, -2.36, -2.107, -2.401, -2.286, -2.16, -2.033, -1.98, -1.939};
    private static final double[] gc3s = new double[]{-2.329, -2.464, -1.785, -2.697, -2.327, -2.14, -1.29, -2.23, -1.95, -1.47, -1.347, -1.272, -1.214};
    private static final double[] gc4 = new double[]{1.45, 1.45, 1.45, 1.45, 1.45, 1.45, 1.55, 1.45, 1.45, 1.5, 1.65, 1.65, 1.65};
    private static final double[] gc5 = new double[]{-0.1, -0.1, -0.1, -0.1, -0.1, -0.1, -0.1, -0.1, -0.1, -0.1, -0.1, -0.1, -0.1};
    private HashMap<Double, Integer> indexFromPerHashMap;
    private int iper;
    private double rRup;
    private double mag;
    private double vs30;
    private double depth;
    private TectonicRegionType subType;
    private EnumParameter<TectonicRegionType> subTypeParam;
    private transient ParameterChangeWarningListener warningListener = null;
    private static final double GC0 = 0.2418;
    private static final double GCS0 = -0.6687;
    private static final double CI = 0.3846;
    private static final double CIS = 0.3643;
    private static final double GCH = 0.00607;
    private static final double GCHS = 0.00648;
    private static final double GMR = 1.414;
    private static final double GMS = 1.438;
    private static final double GEP = 0.554;
    private static final double[] baPer = new double[]{-1.0, 0.0, 0.01, 0.02, 0.03, 0.05, 0.075, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 7.5, 10.0};
    private static final Map<Double, Integer> baPerIdxMap = Maps.newHashMap();
    private static final double[] blin;
    private static final double[] b1;
    private static final double[] b2;
    private static final double V1 = 180.0;
    private static final double V2 = 300.0;
    private static final double A1 = 0.03;
    private static final double A2 = 0.09;
    private static final double A2FAC = 0.405465108;
    private static final double VREF = 760.0;
    private static final double DX = 1.098612289;
    private static final double DXSQ = 1.206948961;
    private static final double DXCUBE = 1.32596896;
    private static final double PLFAC = -0.510825624;

    public YoungsEtAl_1997_AttenRel(ParameterChangeWarningListener listener) {
        this.warningListener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = Maps.newHashMap();
        for (int i = 0; i < pd.length; ++i) {
            this.indexFromPerHashMap.put(pd[i], i);
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
        this.setParamDefaults();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    private void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("Intensity Measure Param not set");
        }
        this.iper = this.indexFromPerHashMap.get(this.saPeriodParam.getValue());
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getMean(this.iper, this.subType, this.vs30, this.rRup, this.mag, this.depth);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper, this.mag);
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.subTypeParam.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.rupTopDepthParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.vs30 = (Double)this.vs30Param.getValue();
        this.subType = (TectonicRegionType)this.subTypeParam.getValue();
        this.rRup = (Double)this.distanceRupParam.getValue();
        this.mag = (Double)this.magParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.rupTopDepthParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.subTypeParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.saPeriodParam);
        this.stdDevIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(150.0, 1500.0);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(7.5);
        this.rupTopDepthParam = new RupTopDepthParam(0.0, 100.0, 20.0);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.rupTopDepthParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        this.distanceRupParam.addParameterChangeWarningListener(this.listener);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint perConstraint = new DoubleDiscreteConstraint();
        for (int i = 0; i < pd.length; ++i) {
            perConstraint.addDouble((Double)pd[i]);
        }
        perConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(perConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.subTypeParam = Params.createSubType();
        this.otherParams.addParameter(this.subTypeParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        } else if (pName.equals("Rupture Top Depth")) {
            this.depth = (Double)val;
        } else if (pName.equals(this.subTypeParam.getName())) {
            this.subType = (TectonicRegionType)val;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.rupTopDepthParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.subTypeParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.rupTopDepthParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
        this.subTypeParam.addParameterChangeListener(this);
    }

    public URL getAttenuationRelationshipURL() throws MalformedURLException {
        return null;
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) {
        return Utils.getExceedProbabilities(imls, this.getMean(), this.getStdDev(), false, 0.0);
    }

    private double getMean(int iper, TectonicRegionType trt, double vs30, double rRup, double mag, double depth) {
        int ir;
        double gm;
        double ge;
        double g4;
        double g3;
        double g2;
        double g1;
        double gz;
        double gnd0;
        double slabVal;
        boolean slab = trt.equals(TectonicRegionType.SUBDUCTION_SLAB);
        double d = slabVal = slab ? 1.0 : 0.0;
        if (slab) {
            mag = Math.min(8.0, mag);
        }
        double gnd0p = 0.2418 + 0.3846 * slabVal;
        if (vs30 > 520.0) {
            gnd0 = 0.2418 + 0.3846 * slabVal;
            gz = 0.00607;
            g1 = gc1[iper];
            g2 = gc2[iper];
            g3 = gc3[iper];
            g4 = 1.7818;
            ge = 0.554;
            gm = 1.414;
            ir = 0;
        } else {
            gnd0 = -0.6687 + 0.3643 * slabVal;
            gz = 0.00648;
            g1 = gc1s[iper];
            g2 = gc2s[iper];
            g3 = gc3s[iper];
            g4 = 1.097;
            ge = 0.617;
            gm = 1.438;
            ir = 1;
        }
        double gndm = gnd0 + g1 + gm * mag + g2 * Math.pow(10.0 - mag, 3.0) + gz * depth;
        double arg = Math.exp(ge * mag);
        double gnd = gndm + g3 * Math.log(rRup + g4 * arg);
        if (vs30 != vgeo[ir]) {
            double gndzp = gnd0p + depth * 0.00607 + gc1[0];
            double gndmp = gndzp + 1.414 * mag + gc2[0] * Math.pow(10.0 - mag, 3.0);
            double argp = Math.exp(0.554 * mag);
            double gndp = gndmp + gc3[0] * Math.log(rRup + 1.7818 * argp);
            double pganl = Math.exp(gndp);
            gnd += YoungsEtAl_1997_AttenRel.baSiteAmp(pganl, vs30, vgeo[ir], iper);
        }
        return gnd;
    }

    private double getStdDev(int iper, double mag) {
        double sig = gc4[iper] + gc5[iper] * Math.min(8.0, mag);
        return sig;
    }

    public static double baSiteAmp(double pganl, double vs30, double vs30r, double per) {
        Preconditions.checkArgument((boolean)baPerIdxMap.containsKey(per), (Object)("Invalid period: " + per));
        int iq = baPerIdxMap.get(per);
        double siter = 0.0;
        double bnl = 180.0 < vs30 && vs30 <= 300.0 ? (b1[iq] - b2[iq]) * Math.log(vs30 / 300.0) / Math.log(0.6) + b2[iq] : (300.0 < vs30 && vs30 <= 760.0 ? b2[iq] * Math.log(vs30 / 760.0) / Math.log(0.39473684210526316) : (vs30 <= 180.0 ? b1[iq] : 0.0));
        double bnlr = 180.0 < vs30r && vs30r <= 300.0 ? (b1[iq] - b2[iq]) * Math.log(vs30r / 300.0) / Math.log(0.6) + b2[iq] : (300.0 < vs30r && vs30r <= 760.0 ? b2[iq] * Math.log(vs30r / 760.0) / Math.log(0.39473684210526316) : (vs30r <= 180.0 ? b1[iq] : 0.0));
        double dy = bnl * 0.405465108;
        double dyr = bnlr * 0.405465108;
        double site = blin[iq] * Math.log(vs30 / 760.0);
        siter = blin[iq] * Math.log(vs30r / 760.0);
        if (pganl <= 0.03) {
            site += bnl * -0.510825624;
            siter += bnlr * -0.510825624;
        } else if (pganl <= 0.09) {
            double c = (3.0 * dy - bnl * 1.098612289) / 1.206948961;
            double d = (bnl * 1.098612289 - 2.0 * dy) / 1.32596896;
            double pgafac = Math.log(pganl / 0.03);
            double psq = pgafac * pgafac;
            site = site + bnl * -0.510825624 + (c + d * pgafac) * psq;
            c = (3.0 * dyr - bnlr * 1.098612289) / 1.206948961;
            d = (bnlr * 1.098612289 - 2.0 * dyr) / 1.32596896;
            siter = siter + bnlr * -0.510825624 + (c + d * pgafac) * psq;
        } else {
            double pgafac = Math.log(pganl / 0.1);
            site += bnl * pgafac;
            siter += bnlr * pgafac;
        }
        return site - siter;
    }

    static {
        int idx = 0;
        for (double d : baPer) {
            baPerIdxMap.put(d, idx++);
        }
        blin = new double[]{-0.6, -0.36, -0.36, -0.34, -0.33, -0.29, -0.23, -0.25, -0.28, -0.31, -0.39, -0.44, -0.5, -0.6, -0.69, -0.7, -0.72, -0.73, -0.74, -0.75, -0.75, -0.692, -0.65};
        b1 = new double[]{-0.5, -0.64, -0.64, -0.63, -0.62, -0.64, -0.64, -0.6, -0.53, -0.52, -0.52, -0.52, -0.51, -0.5, -0.47, -0.44, -0.4, -0.38, -0.34, -0.31, -0.291, -0.247, -0.215};
        b2 = new double[]{-0.06, -0.14, -0.14, -0.12, -0.11, -0.11, -0.11, -0.13, -0.18, -0.19, -0.16, -0.14, -0.1, -0.06, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    }
}

