/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.util;

import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.eq.cat.util.MagnitudeType;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.nshmp2.imr.GridIMR;
import org.opensha.nshmp2.imr.impl.ToroEtAl_1997_AttenRel;
import org.opensha.nshmp2.util.FaultCode;
import org.opensha.nshmp2.util.Period;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.ScalarIMR;

public class CurveTable {
    private final ArrayTable<Double, Double, DiscretizedFunc> curves;
    private final double dR;
    private final double dM;
    private final double minM;
    private static final double DTOR = 5.0;
    private static final double DTOR_SQ = 25.0;

    private CurveTable(List<Double> d, List<Double> m, double dR, double dM, double minM) {
        this.curves = ArrayTable.create(d, m);
        this.dR = dR;
        this.dM = dM;
        this.minM = minM;
    }

    public static CurveTable create(double R, double dR, double minM, double maxM, double dM, ScalarIMR imr, ArbitrarilyDiscretizedFunc model, Function<Double, Double> depthForMag) {
        CurveTable table = CurveTable.initTable(R, dR, minM, maxM, dM);
        table.fillWUS(imr, model, depthForMag);
        return table;
    }

    public static CurveTable create(double R, double dR, double minM, double maxM, double dM, ScalarIMR imr, ArbitrarilyDiscretizedFunc model) {
        CurveTable table = CurveTable.initTable(R, dR, minM, maxM, dM);
        table.fillSLAB(imr, model);
        return table;
    }

    public static CurveTable create(double R, double dR, double minM, double maxM, double dM, Map<ScalarIMR, Double> imrs, ArbitrarilyDiscretizedFunc model, FaultCode magConv) {
        CurveTable table = CurveTable.initTable(R, dR, minM, maxM, dM);
        table.fillCEUS(imrs, model, magConv);
        return table;
    }

    private static CurveTable initTable(double R, double dR, double minM, double maxM, double dM) {
        int numM = (int)Math.round((maxM - minM) / dM);
        int numR = (int)Math.round(R / dR);
        List<Double> rList = CurveTable.sequence(0.0, dR, numR);
        List<Double> mList = CurveTable.sequence(minM, dM, numM);
        CurveTable table = new CurveTable(rList, mList, dR, dM, minM);
        return table;
    }

    private static List<Double> sequence(double start, double interval, int len) {
        double value = start + interval / 2.0;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < len; ++i) {
            list.add(Precision.round((double)value, (int)4));
            value += interval;
        }
        return list;
    }

    public DiscretizedFunc get(double r, double m) {
        return (DiscretizedFunc)this.curves.at(CurveTable.key(r, this.dR), CurveTable.key(m - this.minM, this.dM));
    }

    public int size() {
        return this.curves.size();
    }

    private static final int key(double v, double delta) {
        return (int)(v / delta);
    }

    private void fillWUS(ScalarIMR imr, ArbitrarilyDiscretizedFunc model, Function<Double, Double> depthForMag) {
        UnmodifiableIterator unmodifiableIterator = this.curves.rowKeyList().iterator();
        while (unmodifiableIterator.hasNext()) {
            double r = (Double)unmodifiableIterator.next();
            imr.getParameter("DistanceJB").setValue(r);
            UnmodifiableIterator unmodifiableIterator2 = this.curves.columnKeyList().iterator();
            while (unmodifiableIterator2.hasNext()) {
                double m = (Double)unmodifiableIterator2.next();
                double v = (Double)depthForMag.apply((Object)m);
                imr.getParameter("Rupture Top Depth").setValue(v);
                double rRup = Math.sqrt(r * r + v * v);
                imr.getParameter("DistanceRup").setValue(rRup);
                double rOver = rRup == 0.0 ? 0.0 : (rRup - r) / rRup;
                imr.getParameter("(distRup-distJB)/distRup").setValue(rOver);
                imr.getParameter("Magnitude").setValue(m);
                DiscretizedFunc f = ((GridIMR)((Object)imr)).getExceedProbFromParent(model.deepClone());
                this.curves.put((Object)r, (Object)m, (Object)f);
            }
        }
    }

    private void fillSLAB(ScalarIMR imr, ArbitrarilyDiscretizedFunc model) {
        double v = (Double)imr.getParameter("Rupture Top Depth").getValue();
        double vSq = v * v;
        UnmodifiableIterator unmodifiableIterator = this.curves.rowKeyList().iterator();
        while (unmodifiableIterator.hasNext()) {
            double r = (Double)unmodifiableIterator.next();
            UnmodifiableIterator unmodifiableIterator2 = this.curves.columnKeyList().iterator();
            while (unmodifiableIterator2.hasNext()) {
                double m = (Double)unmodifiableIterator2.next();
                double rRup = Math.sqrt(r * r + vSq);
                imr.getParameter("DistanceRup").setValue(rRup);
                imr.getParameter("Magnitude").setValue(m);
                DiscretizedFunc f = ((GridIMR)((Object)imr)).getExceedProbFromParent(model.deepClone());
                this.curves.put((Object)r, (Object)m, (Object)f);
            }
        }
    }

    private void fillCEUS(Map<ScalarIMR, Double> imrs, ArbitrarilyDiscretizedFunc model, FaultCode magConv) {
        for (ScalarIMR imr : imrs.keySet()) {
            double imrWt = imrs.get(imr);
            UnmodifiableIterator unmodifiableIterator = this.curves.columnKeyList().iterator();
            while (unmodifiableIterator.hasNext()) {
                double m;
                double mag = m = ((Double)unmodifiableIterator.next()).doubleValue();
                if (magConv == FaultCode.M_CONV_AB || magConv == FaultCode.M_CONV_J) {
                    if (imr instanceof ToroEtAl_1997_AttenRel) {
                        imr.getOtherParams().getParameter("Magnitude Type").setValue(MagnitudeType.LG_PHASE);
                    } else {
                        mag = Utils.mblgToMw(magConv, mag);
                    }
                }
                imr.getParameter("Magnitude").setValue(mag);
                UnmodifiableIterator unmodifiableIterator2 = this.curves.rowKeyList().iterator();
                while (unmodifiableIterator2.hasNext()) {
                    double r = (Double)unmodifiableIterator2.next();
                    try {
                        imr.getParameter("DistanceJB").setValue(r);
                    }
                    catch (ParameterException parameterException) {
                        // empty catch block
                    }
                    double rRup = Math.sqrt(r * r + 25.0);
                    try {
                        imr.getParameter("DistanceRup").setValue(rRup);
                    }
                    catch (ParameterException parameterException) {
                        // empty catch block
                    }
                    DiscretizedFunc f = imr.getExceedProbabilities(model.deepClone());
                    f.scale(imrWt);
                    DiscretizedFunc fSum = (DiscretizedFunc)this.curves.get((Object)r, (Object)m);
                    if (fSum == null) {
                        this.curves.put((Object)r, (Object)m, (Object)f);
                        continue;
                    }
                    Utils.addFunc(fSum, f);
                }
            }
        }
    }

    public static void main(String[] args) {
        EnumSet<Period> periods = EnumSet.of(Period.GM0P00);
        HashMap imrs = Maps.newHashMap();
        HashMap imrGrdMap = Maps.newHashMap();
        imrGrdMap.put(AttenRelRef.TORO_1997.instance(null), 0.25);
        imrGrdMap.put(AttenRelRef.FEA_1996.instance(null), 0.125);
        imrGrdMap.put(AttenRelRef.AB_2006_140.instance(null), 0.125);
        imrGrdMap.put(AttenRelRef.AB_2006_200.instance(null), 0.125);
        imrGrdMap.put(AttenRelRef.CAMPBELL_2003.instance(null), 0.125);
        imrGrdMap.put(AttenRelRef.TP_2005.instance(null), 0.125);
        imrGrdMap.put(AttenRelRef.SILVA_2002.instance(null), 0.125);
        Period p = Period.GM0P20;
        ArbitrarilyDiscretizedFunc f = p.getFunction();
        for (ScalarIMR imr : imrGrdMap.keySet()) {
            imr.setIntensityMeasure(p == Period.GM0P00 ? "PGA" : "SA");
            imr.getParameter("SA Period").setValue(p.getValue());
        }
        double mMin = 5.0;
        double mMax = 7.5;
        double rMax = 1000.0;
        Stopwatch sw = Stopwatch.createStarted();
        CurveTable table = CurveTable.create(rMax, 5.0, mMin, mMax, 0.1, imrGrdMap, f, FaultCode.M_CONV_AB);
        sw.stop();
        System.out.println(table.curves.size());
        System.out.println(sw.elapsed(TimeUnit.MILLISECONDS));
        System.out.println(table.get(12.0, 6.55));
        System.out.println(table.curves.at(0, 0));
    }
}

